/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss7;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.plugin.jboss7.objects.Connector;
import org.hyperic.hq.plugin.jboss7.objects.DataSource;
import org.hyperic.hq.plugin.jboss7.objects.DataSource71;
import org.hyperic.hq.plugin.jboss7.objects.Deployment;
import org.hyperic.hq.plugin.jboss7.objects.ServerInfo;
import org.hyperic.hq.plugin.jboss7.objects.ServerMemory;
import org.hyperic.hq.plugin.jboss7.objects.ThreadsInfo;
import org.hyperic.hq.plugin.jboss7.objects.TransactionsStats;
import org.hyperic.hq.plugin.jboss7.objects.WebSubsystem;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.http.HQHttpClient;
import org.hyperic.util.http.HttpConfig;
import org.hyperic.util.security.KeystoreConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBossAdminHttp {
    private static final Log log = LogFactory.getLog(JBossAdminHttp.class);
    private final DefaultHttpClient client;
    private String user;
    private String pass;
    private BasicHttpContext localcontext;
    private HttpHost targetHost;
    private String hostName;
    private String serverName;

    public JBossAdminHttp(Properties props) throws PluginException {
        try {
            int port = Integer.parseInt(props.getProperty("jboss7.port"));
            String addr = props.getProperty("jboss7.addr");
            boolean https = "true".equals(props.getProperty("jboss7.https"));
            this.user = props.getProperty("jboss7.user");
            this.pass = props.getProperty("jboss7.pass");
            this.hostName = props.getProperty("jboss7.host");
            this.serverName = props.getProperty("jboss7.server");
            log.debug((Object)("props=" + props));
            this.targetHost = new HttpHost(addr, port, https ? "https" : "http");
            log.debug((Object)("targetHost=" + this.targetHost));
            AgentKeystoreConfig config = new AgentKeystoreConfig();
            this.client = new HQHttpClient((KeystoreConfig)config, new HttpConfig(5000, 5000, null, 0), config.isAcceptUnverifiedCert());
            if (this.user != null && this.pass != null) {
                this.client.getCredentialsProvider().setCredentials(new AuthScope(this.targetHost.getHostName(), this.targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(this.user, this.pass));
            }
        }
        catch (Throwable ex) {
            throw new PluginException(ex.getMessage(), ex);
        }
    }

    public JBossAdminHttp(ConfigResponse props) throws PluginException {
        this(props.toProperties());
    }

    private String prepareURL() {
        String url = this.targetHost.toURI() + "/management";
        if (this.hostName != null) {
            url = url + "/host/" + this.hostName;
            if (this.serverName != null) {
                url = url + "/server/" + this.serverName;
            }
        }
        return url;
    }

    private Object post(String api, Type type, Map args) throws PluginException {
        GsonBuilder gsb = new GsonBuilder();
        Gson gson = gsb.create();
        String argsJson = gson.toJson((Object)args);
        log.debug((Object)("[post] argsJson=" + argsJson));
        HttpPost post = new HttpPost(this.prepareURL() + api);
        post.setHeader("Content-Type", "application/json");
        try {
            post.setEntity((HttpEntity)new StringEntity(argsJson));
        }
        catch (UnsupportedEncodingException ex) {
            log.debug((Object)ex.getMessage(), (Throwable)ex);
            throw new PluginException(ex.getMessage(), (Throwable)ex);
        }
        return this.query((HttpRequestBase)post, api, type);
    }

    private Object get(String api, Type type) throws PluginException {
        HttpGet get = new HttpGet(this.prepareURL() + api);
        return this.query((HttpRequestBase)get, api, type);
    }

    private Object query(HttpRequestBase req, String api, Type type) throws PluginException {
        Object res = null;
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)req, (HttpContext)this.localcontext);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseBody = JBossAdminHttp.readInputString(response.getEntity().getContent());
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + api + "] -(" + req.getURI() + ")-> " + responseBody));
            }
            if (statusCode != 200) {
                throw new PluginException("[" + req.getURI() + "] http error code: '" + statusCode + "' msg='" + response.getStatusLine().getReasonPhrase() + "'");
            }
            GsonBuilder gsb = new GsonBuilder();
            if (!(type instanceof Class) || !((Class)type).getCanonicalName().equals(Connector.class.getCanonicalName())) {
                gsb.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_DASHES);
            }
            Gson gson = gsb.create();
            res = gson.fromJson(responseBody, type);
            if (log.isDebugEnabled()) {
                if (res.getClass().isArray()) {
                    log.debug((Object)("[" + api + "] -(" + statusCode + ")*> " + Arrays.asList((Object[])res)));
                } else {
                    log.debug((Object)("[" + api + "] -(" + statusCode + ")-> " + res));
                }
            }
        }
        catch (JsonParseException ex) {
            log.debug((Object)ex.getMessage(), (Throwable)ex);
            throw new PluginException(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            log.debug((Object)ex.getMessage(), (Throwable)ex);
            throw new PluginException(ex.getMessage(), (Throwable)ex);
        }
        return res;
    }

    public WebSubsystem getWebSubsystem() throws PluginException {
        Type type = new TypeToken<WebSubsystem>(){}.getType();
        return (WebSubsystem)this.get("/subsystem/web?recursive=true", type);
    }

    public Connector getConnector(String connector) throws PluginException {
        Type type = new TypeToken<Connector>(){}.getType();
        try {
            connector = URLEncoder.encode(connector, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return (Connector)this.get("/subsystem/web/connector/" + connector + "?include-runtime=true", type);
    }

    public ThreadsInfo getThreadsInfo() throws PluginException {
        Type type = new TypeToken<ThreadsInfo>(){}.getType();
        return (ThreadsInfo)this.get("/core-service/platform-mbean/type/threading", type);
    }

    public ServerMemory getServerMemory() throws PluginException {
        Type type = new TypeToken<ServerMemory>(){}.getType();
        return (ServerMemory)this.get("/core-service/platform-mbean/type/memory?include-runtime=true", type);
    }

    public TransactionsStats getTransactionsStats() throws PluginException {
        Type type = new TypeToken<TransactionsStats>(){}.getType();
        return (TransactionsStats)this.get("/subsystem/transactions?include-runtime=true", type);
    }

    public List<Deployment> getDeployments() throws PluginException {
        Type type = new TypeToken<List<Deployment>>(){}.getType();
        return (List)this.get("/deployment/*?recursive=true", type);
    }

    public List<String> getDatasources() throws PluginException {
        Type type = new TypeToken<Map<String, Map<String, Object>>>(){}.getType();
        Map ds = (Map)this.get("/subsystem/datasources", type);
        ArrayList<String> res = new ArrayList<String>();
        if (ds.get("data-source") != null) {
            res.addAll(((Map)ds.get("data-source")).keySet());
        }
        if (ds.get("xa-data-source") != null) {
            res.addAll(((Map)ds.get("xa-data-source")).keySet());
        }
        return res;
    }

    public DataSource getDatasource(String ds, boolean runtime, String jbossVersion) throws PluginException {
        Type type = jbossVersion.equalsIgnoreCase("7") ? new TypeToken<DataSource>(){}.getType() : new TypeToken<DataSource71>(){}.getType();
        try {
            ds = URLEncoder.encode(ds, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        if (runtime) {
            ds = ds + "?include-runtime=true";
            if (!jbossVersion.equalsIgnoreCase("7")) {
                ds = ds + "&recursive";
            }
        }
        DataSource res = (DataSource)this.get("/subsystem/datasources/data-source/" + ds, type);
        return res;
    }

    public void shutdown() throws PluginException {
        this.executeCommand("shutdown");
    }

    public void stop() throws PluginException {
        this.executeCommand("stop");
    }

    public void start() throws PluginException {
        this.executeCommand("start");
    }

    public void restart() throws PluginException {
        this.executeCommand("restart");
    }

    private void executeCommand(String command) throws PluginException {
        Type type = new TypeToken<Map>(){}.getType();
        HashMap<String, String> address = null;
        if (this.hostName != null) {
            address = new HashMap<String, String>();
            address.put("host", this.hostName);
            if (this.serverName != null) {
                address.put("server-config", this.serverName);
            }
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("operation", command);
        if (address != null) {
            args.put("address", address);
        }
        try {
            Map res = (Map)this.post("", type, args);
            log.debug((Object)("[executeCommand][" + command + "] res=" + res));
        }
        catch (PluginException ex) {
            if (ex.getCause() instanceof NoHttpResponseException && this.hostName != null) {
                log.debug((Object)("[executeCommand][" + command + "] executed with execiton '" + ex.getMessage() + "' => maybe a JBoss bug"));
            }
            throw ex;
        }
    }

    void testConnection() throws PluginException {
        Type type = new TypeToken<ServerInfo>(){}.getType();
        this.get("/", type);
    }

    public static String readInputString(InputStream in) throws IOException {
        int n;
        StringBuilder out = new StringBuilder();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }
}

