/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss7;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.hyperic.hq.plugin.jboss7.JBossHostControllerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.util.config.ConfigResponse;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossManagedDetector
extends JBossHostControllerDetector {
    private final Log log = this.getLog();

    @Override
    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        List controllers = super.getServerResources(platformConfig);
        for (ServerResource controller : controllers) {
            List<String> serversNames = this.getServersNames(controller.getIdentifier());
            for (String serverName : serversNames) {
                ServerResource server = this.createServerResource(controller.getInstallPath());
                server.setIdentifier(serverName + "-" + controller.getIdentifier());
                ConfigResponse pc = controller.getProductConfig();
                pc.setValue("jboss7.server", serverName);
                this.setProductConfig(server, pc);
                this.setControlConfig(server, new ConfigResponse());
                server.setName(this.prepareServerName(server.getProductConfig()));
                servers.add(server);
            }
        }
        return servers;
    }

    private List<String> getServersNames(String config) {
        ArrayList<String> names = new ArrayList<String>();
        File cfgFile = new File(config);
        try {
            this.log.debug((Object)("[getServerProductConfig] cfgFile=" + cfgFile.getCanonicalPath()));
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(cfgFile);
            XPathFactory factory = XPathFactory.newInstance();
            XPathExpression expr = factory.newXPath().compile("//host/servers/server");
            Object result = expr.evaluate(doc, XPathConstants.NODESET);
            NodeList nodeList = (NodeList)result;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                names.add(nodeList.item(i).getAttributes().getNamedItem("name").getNodeValue());
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)("Error discovering the servers names : " + ex), (Throwable)ex);
        }
        return names;
    }

    @Override
    boolean haveServices() {
        return true;
    }
}

