/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.control.agent.server;

import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.ControlCallbackClient;
import org.hyperic.hq.bizapp.shared.lather.ControlSendCommandResult_args;
import org.hyperic.hq.product.ControlPluginManager;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.util.config.ConfigResponse;

class ActionThread
extends Thread {
    private ControlPluginManager manager;
    private ControlCallbackClient client;
    private String pluginName;
    private String pluginType;
    private String action;
    private String[] args;
    private String id;
    protected static final int REQUEUE_INTERVAL = 2000;
    protected Log log = LogFactory.getLog((String)ActionThread.class.getName());

    ActionThread(String pluginName, String pluginType, String id, String action, String[] args, ControlCallbackClient client, ControlPluginManager manager) {
        this.pluginName = pluginName;
        this.pluginType = pluginType;
        this.id = id;
        this.action = action;
        this.args = args;
        this.client = client;
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block37: {
            int result = -1;
            String errMsg = null;
            this.log.debug((Object)("Adding job " + this.id + " to " + this.pluginName + " queue"));
            this.manager.addJob(this.pluginName, this.id);
            while (true) {
                String nextJob;
                try {
                    nextJob = this.manager.getNextJob(this.pluginName);
                    if (nextJob.equals(this.id)) {
                        break;
                    }
                }
                catch (NoSuchElementException e) {
                    this.log.error((Object)"Job queue empty");
                    return;
                }
                this.log.debug((Object)("Plugin busy with job " + nextJob + " requeueing in " + 2000 + "ms"));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {}
            }
            this.log.debug((Object)("Running job " + this.id));
            long startTime = System.currentTimeMillis();
            ControlSendCommandResult_args resultsMetadata = this.client.newResultsMetadata(this.pluginName, Integer.parseInt(this.id), startTime);
            this.manager.doAction(this.pluginName, this.action, this.args, resultsMetadata);
            result = this.manager.getResult(this.pluginName);
            errMsg = this.manager.getMessage(this.pluginName);
            try {
                this.manager.removeNextJob(this.pluginName);
                this.log.debug((Object)("Removed job " + this.id + " from the queue"));
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            try {
                this.client.controlSendCommandResult(resultsMetadata, result, errMsg);
            }
            catch (AgentCallbackClientException e) {
                this.log.error((Object)("Unable to send command result: " + e.getMessage()));
            }
            break block37;
            catch (PluginNotFoundException e) {
                byte[] configBytes;
                block36: {
                    this.log.info((Object)"Fetching plugin configuration from server");
                    configBytes = this.client.controlGetPluginConfiguration(this.pluginName);
                    if (configBytes != null && configBytes.length != 0) break block36;
                    errMsg = "Plugin configuration not found";
                    this.log.error((Object)errMsg);
                    try {
                        this.manager.removeNextJob(this.pluginName);
                        this.log.debug((Object)("Removed job " + this.id + " from the queue"));
                    }
                    catch (NoSuchElementException e2) {
                        // empty catch block
                    }
                    try {
                        this.client.controlSendCommandResult(resultsMetadata, result, errMsg);
                    }
                    catch (AgentCallbackClientException e3) {
                        this.log.error((Object)("Unable to send command result: " + e3.getMessage()));
                    }
                    return;
                }
                ConfigResponse config = ConfigResponse.decode((byte[])configBytes);
                this.log.info((Object)"Config finished, running control action");
                this.manager.createControlPlugin(this.pluginName, this.pluginType, config);
                this.manager.doAction(this.pluginName, this.action, this.args, resultsMetadata);
                result = this.manager.getResult(this.pluginName);
                errMsg = this.manager.getMessage(this.pluginName);
                {
                    catch (Exception exc) {
                        errMsg = "Unable to fetch plugin configuration: " + exc.getMessage();
                        this.log.error((Object)errMsg, (Throwable)exc);
                    }
                }
                try {
                    this.manager.removeNextJob(this.pluginName);
                    this.log.debug((Object)("Removed job " + this.id + " from the queue"));
                }
                catch (NoSuchElementException e4) {
                    // empty catch block
                }
                try {
                    this.client.controlSendCommandResult(resultsMetadata, result, errMsg);
                }
                catch (AgentCallbackClientException e5) {
                    this.log.error((Object)("Unable to send command result: " + e5.getMessage()));
                }
            }
            catch (PluginException e2) {
                errMsg = "Unable to run control action:  " + e2.getMessage();
                this.log.error((Object)errMsg, (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        try {
                            this.manager.removeNextJob(this.pluginName);
                            this.log.debug((Object)("Removed job " + this.id + " from the queue"));
                        }
                        catch (NoSuchElementException e6) {
                            // empty catch block
                        }
                        try {
                            this.client.controlSendCommandResult(resultsMetadata, result, errMsg);
                        }
                        catch (AgentCallbackClientException e7) {
                            this.log.error((Object)("Unable to send command result: " + e7.getMessage()));
                        }
                        throw throwable;
                    }
                }
                try {
                    this.manager.removeNextJob(this.pluginName);
                    this.log.debug((Object)("Removed job " + this.id + " from the queue"));
                }
                catch (NoSuchElementException e8) {
                    // empty catch block
                }
                try {
                    this.client.controlSendCommandResult(resultsMetadata, result, errMsg);
                }
                catch (AgentCallbackClientException e9) {
                    this.log.error((Object)("Unable to send command result: " + e9.getMessage()));
                }
            }
        }
    }
}

