/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.utils;

import com.sun.org.apache.xalan.internal.utils.ObjectFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public final class SecuritySupport {
    private static final SecuritySupport securitySupport = new SecuritySupport();
    static final Properties cacheProps = new Properties();
    static volatile boolean firstTime = true;

    public static SecuritySupport getInstance() {
        return securitySupport;
    }

    static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classLoader;
            }
        });
    }

    static ClassLoader getSystemClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classLoader;
            }
        });
    }

    static ClassLoader getParentClassLoader(final ClassLoader classLoader) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader2 = null;
                try {
                    classLoader2 = classLoader.getParent();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classLoader2 == classLoader ? null : classLoader2;
            }
        });
    }

    public static String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    public static String getSystemProperty(final String string, final String string2) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string, string2);
            }
        });
    }

    static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
    }

    public static InputStream getResourceAsStream(String string) {
        if (System.getSecurityManager() != null) {
            return SecuritySupport.getResourceAsStream(null, string);
        }
        return SecuritySupport.getResourceAsStream(ObjectFactory.findClassLoader(), string);
    }

    public static InputStream getResourceAsStream(final ClassLoader classLoader, final String string) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InputStream inputStream = classLoader == null ? Object.class.getResourceAsStream("/" + string) : classLoader.getResourceAsStream(string);
                return inputStream;
            }
        });
    }

    public static ListResourceBundle getResourceBundle(String string) {
        return SecuritySupport.getResourceBundle(string, Locale.getDefault());
    }

    public static ListResourceBundle getResourceBundle(final String string, final Locale locale) {
        return AccessController.doPrivileged(new PrivilegedAction<ListResourceBundle>(){

            @Override
            public ListResourceBundle run() {
                try {
                    return (ListResourceBundle)ResourceBundle.getBundle(string, locale);
                }
                catch (MissingResourceException missingResourceException) {
                    try {
                        return (ListResourceBundle)ResourceBundle.getBundle(string, new Locale("en", "US"));
                    }
                    catch (MissingResourceException missingResourceException2) {
                        throw new MissingResourceException("Could not load any resource bundle by " + string, string, "");
                    }
                }
            }
        });
    }

    public static boolean getFileExists(final File file) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.exists() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    static long getLastModified(final File file) {
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(file.lastModified());
            }
        });
    }

    public static String sanitizePath(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf("/");
        if (n > 0) {
            return string.substring(n + 1, string.length());
        }
        return "";
    }

    public static String checkAccess(String string, String string2, String string3) throws IOException {
        String string4;
        if (string == null || string2 != null && string2.equalsIgnoreCase(string3)) {
            return null;
        }
        if (string.indexOf(":") == -1) {
            string4 = "file";
        } else {
            URL uRL = new URL(string);
            string4 = uRL.getProtocol();
            if (string4.equalsIgnoreCase("jar")) {
                String string5 = uRL.getPath();
                string4 = string5.substring(0, string5.indexOf(":"));
            }
        }
        if (SecuritySupport.isProtocolAllowed(string4, string2)) {
            return null;
        }
        return string4;
    }

    private static boolean isProtocolAllowed(String string, String string2) {
        String[] stringArray;
        if (string2 == null) {
            return false;
        }
        for (String string3 : stringArray = string2.split(",")) {
            if (!(string3 = string3.trim()).equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static String getJAXPSystemProperty(String string) {
        String string2 = SecuritySupport.getSystemProperty(string);
        if (string2 == null) {
            string2 = SecuritySupport.readJAXPProperty(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readJAXPProperty(String string) {
        String string2 = null;
        InputStream inputStream = null;
        try {
            if (firstTime) {
                Properties properties = cacheProps;
                synchronized (properties) {
                    if (firstTime) {
                        String string3 = SecuritySupport.getSystemProperty("java.home") + File.separator + "lib" + File.separator + "jaxp.properties";
                        File file = new File(string3);
                        if (SecuritySupport.getFileExists(file)) {
                            inputStream = SecuritySupport.getFileInputStream(file);
                            cacheProps.load(inputStream);
                        }
                        firstTime = false;
                    }
                }
            }
            string2 = cacheProps.getProperty(string);
        }
        catch (Exception exception) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string2;
    }

    private SecuritySupport() {
    }
}

