/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.validation;

import com.sun.org.apache.xerces.internal.impl.Constants;
import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.validation.ValidationManager;
import com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaValidator;
import com.sun.org.apache.xerces.internal.impl.xs.XSMessageFormatter;
import com.sun.org.apache.xerces.internal.jaxp.validation.DraconianErrorHandler;
import com.sun.org.apache.xerces.internal.jaxp.validation.XSGrammarPoolContainer;
import com.sun.org.apache.xerces.internal.util.DOMEntityResolverWrapper;
import com.sun.org.apache.xerces.internal.util.ErrorHandlerWrapper;
import com.sun.org.apache.xerces.internal.util.FeatureState;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.ParserConfigurationSettings;
import com.sun.org.apache.xerces.internal.util.PropertyState;
import com.sun.org.apache.xerces.internal.util.SecurityManager;
import com.sun.org.apache.xerces.internal.util.Status;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.utils.XMLSecurityPropertyManager;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponent;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;

final class XMLSchemaValidatorComponentManager
extends ParserConfigurationSettings
implements XMLComponentManager {
    private static final String SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    private static final String VALIDATION = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_ELEMENT_DEFAULT = "http://apache.org/xml/features/validation/schema/element-default";
    private static final String USE_GRAMMAR_POOL_ONLY = "http://apache.org/xml/features/internal/validation/schema/use-grammar-pool-only";
    private static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    private static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    private static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String NAMESPACE_CONTEXT = "http://apache.org/xml/properties/internal/namespace-context";
    private static final String SCHEMA_VALIDATOR = "http://apache.org/xml/properties/internal/validator/schema";
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private static final String XML_SECURITY_PROPERTY_MANAGER = "http://www.oracle.com/xml/jaxp/properties/xmlSecurityPropertyManager";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    private static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final String LOCALE = "http://apache.org/xml/properties/locale";
    private boolean _isSecureMode = false;
    private boolean fConfigUpdated = true;
    private boolean fUseGrammarPoolOnly;
    private final HashMap fComponents = new HashMap();
    private XMLEntityManager fEntityManager;
    private XMLErrorReporter fErrorReporter;
    private NamespaceContext fNamespaceContext;
    private XMLSchemaValidator fSchemaValidator;
    private ValidationManager fValidationManager;
    private final HashMap fInitFeatures = new HashMap();
    private final HashMap fInitProperties = new HashMap();
    private final SecurityManager fInitSecurityManager;
    private final XMLSecurityPropertyManager fSecurityPropertyMgr;
    private ErrorHandler fErrorHandler = null;
    private LSResourceResolver fResourceResolver = null;
    private Locale fLocale = null;

    public XMLSchemaValidatorComponentManager(XSGrammarPoolContainer xSGrammarPoolContainer) {
        this.fEntityManager = new XMLEntityManager();
        this.fComponents.put(ENTITY_MANAGER, this.fEntityManager);
        this.fErrorReporter = new XMLErrorReporter();
        this.fComponents.put(ERROR_REPORTER, this.fErrorReporter);
        this.fNamespaceContext = new NamespaceSupport();
        this.fComponents.put(NAMESPACE_CONTEXT, this.fNamespaceContext);
        this.fSchemaValidator = new XMLSchemaValidator();
        this.fComponents.put(SCHEMA_VALIDATOR, this.fSchemaValidator);
        this.fValidationManager = new ValidationManager();
        this.fComponents.put(VALIDATION_MANAGER, this.fValidationManager);
        this.fComponents.put(ENTITY_RESOLVER, null);
        this.fComponents.put(ERROR_HANDLER, null);
        if (System.getSecurityManager() != null) {
            this._isSecureMode = true;
            this.setProperty(SECURITY_MANAGER, new SecurityManager());
        } else {
            this.fComponents.put(SECURITY_MANAGER, null);
        }
        this.fComponents.put(SYMBOL_TABLE, new SymbolTable());
        this.fComponents.put(XMLGRAMMAR_POOL, xSGrammarPoolContainer.getGrammarPool());
        this.fUseGrammarPoolOnly = xSGrammarPoolContainer.isFullyComposed();
        this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", new XSMessageFormatter());
        this.addRecognizedParamsAndSetDefaults(this.fEntityManager, xSGrammarPoolContainer);
        this.addRecognizedParamsAndSetDefaults(this.fErrorReporter, xSGrammarPoolContainer);
        this.addRecognizedParamsAndSetDefaults(this.fSchemaValidator, xSGrammarPoolContainer);
        Boolean bl = xSGrammarPoolContainer.getFeature("http://javax.xml.XMLConstants/feature/secure-processing");
        this.fInitSecurityManager = Boolean.TRUE.equals(bl) ? new SecurityManager() : null;
        this.fComponents.put(SECURITY_MANAGER, this.fInitSecurityManager);
        this.fSecurityPropertyMgr = (XMLSecurityPropertyManager)xSGrammarPoolContainer.getProperty(XML_SECURITY_PROPERTY_MANAGER);
        this.setProperty(XML_SECURITY_PROPERTY_MANAGER, this.fSecurityPropertyMgr);
    }

    @Override
    public FeatureState getFeatureState(String string) throws XMLConfigurationException {
        if ("http://apache.org/xml/features/internal/parser-settings".equals(string)) {
            return FeatureState.is(this.fConfigUpdated);
        }
        if (VALIDATION.equals(string) || SCHEMA_VALIDATION.equals(string)) {
            return FeatureState.is(true);
        }
        if (USE_GRAMMAR_POOL_ONLY.equals(string)) {
            return FeatureState.is(this.fUseGrammarPoolOnly);
        }
        if ("http://javax.xml.XMLConstants/feature/secure-processing".equals(string)) {
            return FeatureState.is(this.getProperty(SECURITY_MANAGER) != null);
        }
        if (SCHEMA_ELEMENT_DEFAULT.equals(string)) {
            return FeatureState.is(true);
        }
        return super.getFeatureState(string);
    }

    @Override
    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        if ("http://apache.org/xml/features/internal/parser-settings".equals(string)) {
            throw new XMLConfigurationException(Status.NOT_SUPPORTED, string);
        }
        if (!bl && (VALIDATION.equals(string) || SCHEMA_VALIDATION.equals(string))) {
            throw new XMLConfigurationException(Status.NOT_SUPPORTED, string);
        }
        if (USE_GRAMMAR_POOL_ONLY.equals(string) && bl != this.fUseGrammarPoolOnly) {
            throw new XMLConfigurationException(Status.NOT_SUPPORTED, string);
        }
        if ("http://javax.xml.XMLConstants/feature/secure-processing".equals(string)) {
            if (this._isSecureMode && !bl) {
                throw new XMLConfigurationException(Status.NOT_ALLOWED, "http://javax.xml.XMLConstants/feature/secure-processing");
            }
            this.setProperty(SECURITY_MANAGER, bl ? new SecurityManager() : null);
            if (bl && Constants.IS_JDK8_OR_ABOVE) {
                this.fSecurityPropertyMgr.setValue(XMLSecurityPropertyManager.Property.ACCESS_EXTERNAL_DTD, XMLSecurityPropertyManager.State.FSP, "");
                this.fSecurityPropertyMgr.setValue(XMLSecurityPropertyManager.Property.ACCESS_EXTERNAL_SCHEMA, XMLSecurityPropertyManager.State.FSP, "");
                this.setProperty(XML_SECURITY_PROPERTY_MANAGER, this.fSecurityPropertyMgr);
            }
            return;
        }
        this.fConfigUpdated = true;
        this.fEntityManager.setFeature(string, bl);
        this.fErrorReporter.setFeature(string, bl);
        this.fSchemaValidator.setFeature(string, bl);
        if (!this.fInitFeatures.containsKey(string)) {
            boolean bl2 = super.getFeature(string);
            this.fInitFeatures.put(string, bl2 ? Boolean.TRUE : Boolean.FALSE);
        }
        super.setFeature(string, bl);
    }

    @Override
    public PropertyState getPropertyState(String string) throws XMLConfigurationException {
        if (LOCALE.equals(string)) {
            return PropertyState.is(this.getLocale());
        }
        Object v = this.fComponents.get(string);
        if (v != null) {
            return PropertyState.is(v);
        }
        if (this.fComponents.containsKey(string)) {
            return PropertyState.is(null);
        }
        return super.getPropertyState(string);
    }

    @Override
    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (ENTITY_MANAGER.equals(string) || ERROR_REPORTER.equals(string) || NAMESPACE_CONTEXT.equals(string) || SCHEMA_VALIDATOR.equals(string) || SYMBOL_TABLE.equals(string) || VALIDATION_MANAGER.equals(string) || XMLGRAMMAR_POOL.equals(string)) {
            throw new XMLConfigurationException(Status.NOT_SUPPORTED, string);
        }
        this.fConfigUpdated = true;
        this.fEntityManager.setProperty(string, object);
        this.fErrorReporter.setProperty(string, object);
        this.fSchemaValidator.setProperty(string, object);
        if (ENTITY_RESOLVER.equals(string) || ERROR_HANDLER.equals(string) || SECURITY_MANAGER.equals(string)) {
            this.fComponents.put(string, object);
            return;
        }
        if (LOCALE.equals(string)) {
            this.setLocale((Locale)object);
            this.fComponents.put(string, object);
            return;
        }
        if (!this.fInitProperties.containsKey(string)) {
            this.fInitProperties.put(string, super.getProperty(string));
        }
        super.setProperty(string, object);
    }

    public void addRecognizedParamsAndSetDefaults(XMLComponent xMLComponent, XSGrammarPoolContainer xSGrammarPoolContainer) {
        String[] stringArray = xMLComponent.getRecognizedFeatures();
        this.addRecognizedFeatures(stringArray);
        String[] stringArray2 = xMLComponent.getRecognizedProperties();
        this.addRecognizedProperties(stringArray2);
        this.setFeatureDefaults(xMLComponent, stringArray, xSGrammarPoolContainer);
        this.setPropertyDefaults(xMLComponent, stringArray2);
    }

    public void reset() throws XNIException {
        this.fNamespaceContext.reset();
        this.fValidationManager.reset();
        this.fEntityManager.reset(this);
        this.fErrorReporter.reset(this);
        this.fSchemaValidator.reset(this);
        this.fConfigUpdated = false;
    }

    void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
        this.setProperty(ERROR_HANDLER, errorHandler != null ? new ErrorHandlerWrapper(errorHandler) : new ErrorHandlerWrapper(DraconianErrorHandler.getInstance()));
    }

    ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    void setResourceResolver(LSResourceResolver lSResourceResolver) {
        this.fResourceResolver = lSResourceResolver;
        this.setProperty(ENTITY_RESOLVER, new DOMEntityResolverWrapper(lSResourceResolver));
    }

    LSResourceResolver getResourceResolver() {
        return this.fResourceResolver;
    }

    void setLocale(Locale locale) {
        this.fLocale = locale;
        this.fErrorReporter.setLocale(locale);
    }

    Locale getLocale() {
        return this.fLocale;
    }

    void restoreInitialState() {
        String string;
        this.fConfigUpdated = true;
        this.fComponents.put(ENTITY_RESOLVER, null);
        this.fComponents.put(ERROR_HANDLER, null);
        this.setLocale(null);
        this.fComponents.put(LOCALE, null);
        this.fComponents.put(SECURITY_MANAGER, this.fInitSecurityManager);
        this.setLocale(null);
        this.fComponents.put(LOCALE, null);
        if (!this.fInitFeatures.isEmpty()) {
            for (Map.Entry entry : this.fInitFeatures.entrySet()) {
                string = (String)entry.getKey();
                boolean bl = (Boolean)entry.getValue();
                super.setFeature(string, bl);
            }
            this.fInitFeatures.clear();
        }
        if (!this.fInitProperties.isEmpty()) {
            for (Map.Entry entry : this.fInitProperties.entrySet()) {
                string = (String)entry.getKey();
                Object v = entry.getValue();
                super.setProperty(string, v);
            }
            this.fInitProperties.clear();
        }
    }

    private void setFeatureDefaults(XMLComponent xMLComponent, String[] stringArray, XSGrammarPoolContainer xSGrammarPoolContainer) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                Boolean bl = xSGrammarPoolContainer.getFeature(string);
                if (bl == null) {
                    bl = xMLComponent.getFeatureDefault(string);
                }
                if (bl == null || this.fFeatures.containsKey(string)) continue;
                this.fFeatures.put(string, bl);
                this.fConfigUpdated = true;
            }
        }
    }

    private void setPropertyDefaults(XMLComponent xMLComponent, String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                Object object = xMLComponent.getPropertyDefault(string);
                if (object == null || this.fProperties.containsKey(string)) continue;
                this.fProperties.put(string, object);
                this.fConfigUpdated = true;
            }
        }
    }
}

