/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.optimizer;

import java.util.Map;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.Node;
import sun.org.mozilla.javascript.internal.NodeTransformer;
import sun.org.mozilla.javascript.internal.ObjArray;
import sun.org.mozilla.javascript.internal.ast.ScriptNode;
import sun.org.mozilla.javascript.internal.optimizer.OptFunctionNode;

class OptTransformer
extends NodeTransformer {
    private Map<String, OptFunctionNode> possibleDirectCalls;
    private ObjArray directCallTargets;

    OptTransformer(Map<String, OptFunctionNode> map, ObjArray objArray) {
        this.possibleDirectCalls = map;
        this.directCallTargets = objArray;
    }

    @Override
    protected void visitNew(Node node, ScriptNode scriptNode) {
        this.detectDirectCall(node, scriptNode);
        super.visitNew(node, scriptNode);
    }

    @Override
    protected void visitCall(Node node, ScriptNode scriptNode) {
        this.detectDirectCall(node, scriptNode);
        super.visitCall(node, scriptNode);
    }

    private void detectDirectCall(Node node, ScriptNode scriptNode) {
        if (scriptNode.getType() == 109) {
            Node node2 = node.getFirstChild();
            int n = 0;
            Node node3 = node2.getNext();
            while (node3 != null) {
                node3 = node3.getNext();
                ++n;
            }
            if (n == 0) {
                OptFunctionNode.get((ScriptNode)scriptNode).itsContainsCalls0 = true;
            }
            if (this.possibleDirectCalls != null) {
                OptFunctionNode optFunctionNode;
                String string = null;
                if (node2.getType() == 39) {
                    string = node2.getString();
                } else if (node2.getType() == 33) {
                    string = node2.getFirstChild().getNext().getString();
                } else if (node2.getType() == 34) {
                    throw Kit.codeBug();
                }
                if (string != null && (optFunctionNode = this.possibleDirectCalls.get(string)) != null && n == optFunctionNode.fnode.getParamCount() && !optFunctionNode.fnode.requiresActivation() && n <= 32) {
                    node.putProp(9, optFunctionNode);
                    if (!optFunctionNode.isTargetOfDirectCall()) {
                        int n2 = this.directCallTargets.size();
                        this.directCallTargets.add(optFunctionNode);
                        optFunctionNode.setDirectTargetIndex(n2);
                    }
                }
            }
        }
    }
}

