/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Network;
import com.xensource.xenapi.PIF;
import com.xensource.xenapi.SR;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pool
extends XenAPIObject {
    protected final String ref;
    private static final Map<String, SoftReference<Pool>> cache = new HashMap<String, SoftReference<Pool>>();

    private Pool(String ref) {
        this.ref = ref;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    protected static synchronized Pool getInstFromRef(String ref) {
        Pool instance;
        if (cache.containsKey(ref) && (instance = cache.get(ref).get()) != null) {
            return instance;
        }
        instance = new Pool(ref);
        cache.put(ref, new SoftReference<Pool>(instance));
        return instance;
    }

    public Record getRecord(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.get_record";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toPoolRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Pool getByUuid(Connection c, String uuid) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.get_by_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(uuid)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toPool(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getUuid(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.get_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getNameLabel(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.get_name_label";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getNameDescription(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.get_name_description";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Host getMaster(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.get_master";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toHost(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public SR getDefaultSR(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.get_default_SR";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSR(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public SR getSuspendImageSR(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.get_suspend_image_SR";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSR(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public SR getCrashDumpSR(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.get_crash_dump_SR";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSR(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getOtherConfig(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.get_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void setNameLabel(Connection c, String nameLabel) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.set_name_label";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(nameLabel)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setNameDescription(Connection c, String nameDescription) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.set_name_description";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(nameDescription)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setDefaultSR(Connection c, SR defaultSR) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.set_default_SR";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(defaultSR)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setSuspendImageSR(Connection c, SR suspendImageSR) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.set_suspend_image_SR";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(suspendImageSR)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setCrashDumpSR(Connection c, SR crashDumpSR) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.set_crash_dump_SR";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(crashDumpSR)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setOtherConfig(Connection c, Map<String, String> otherConfig) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.set_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(otherConfig)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void addToOtherConfig(Connection c, String key, String value) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.add_to_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key), Marshalling.toXMLRPC(value)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void removeFromOtherConfig(Connection c, String key) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.remove_from_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static Task joinAsync(Connection c, String masterAddress, String masterUsername, String masterPassword) throws Types.BadServerResponse, XmlRpcException, Types.JoiningHostCannotContainSharedSrs {
        Object[] error;
        String method_call = "Async.pool.join";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(masterAddress), Marshalling.toXMLRPC(masterUsername), Marshalling.toXMLRPC(masterPassword)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure") && (error = (Object[])response.get("ErrorDescription"))[0].equals("JOINING_HOST_CANNOT_CONTAIN_SHARED_SRS")) {
            throw new Types.JoiningHostCannotContainSharedSrs();
        }
        throw new Types.BadServerResponse(response);
    }

    public static void join(Connection c, String masterAddress, String masterUsername, String masterPassword) throws Types.BadServerResponse, XmlRpcException, Types.JoiningHostCannotContainSharedSrs {
        Object[] error;
        String method_call = "pool.join";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(masterAddress), Marshalling.toXMLRPC(masterUsername), Marshalling.toXMLRPC(masterPassword)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure") && (error = (Object[])response.get("ErrorDescription"))[0].equals("JOINING_HOST_CANNOT_CONTAIN_SHARED_SRS")) {
            throw new Types.JoiningHostCannotContainSharedSrs();
        }
        throw new Types.BadServerResponse(response);
    }

    public static Task joinForceAsync(Connection c, String masterAddress, String masterUsername, String masterPassword) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.pool.join_force";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(masterAddress), Marshalling.toXMLRPC(masterUsername), Marshalling.toXMLRPC(masterPassword)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static void joinForce(Connection c, String masterAddress, String masterUsername, String masterPassword) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.join_force";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(masterAddress), Marshalling.toXMLRPC(masterUsername), Marshalling.toXMLRPC(masterPassword)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static Task ejectAsync(Connection c, Host host) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.pool.eject";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(host)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static void eject(Connection c, Host host) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.eject";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(host)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static void emergencyTransitionToMaster(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.emergency_transition_to_master";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static void emergencyResetMaster(Connection c, String masterAddress) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.emergency_reset_master";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(masterAddress)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static Task recoverSlavesAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.pool.recover_slaves";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Set<Host> recoverSlaves(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.recover_slaves";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfHost(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Task createVLANAsync(Connection c, String device, Network network, Long VLAN2) throws Types.BadServerResponse, XmlRpcException, Types.VlanTagInvalid {
        Object[] error;
        String method_call = "Async.pool.create_VLAN";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(device), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(VLAN2)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure") && (error = (Object[])response.get("ErrorDescription"))[0].equals("VLAN_TAG_INVALID")) {
            throw new Types.VlanTagInvalid((String)error[1]);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Set<PIF> createVLAN(Connection c, String device, Network network, Long VLAN2) throws Types.BadServerResponse, XmlRpcException, Types.VlanTagInvalid {
        Object[] error;
        String method_call = "pool.create_VLAN";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(device), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(VLAN2)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfPIF(result);
        }
        if (response.get("Status").equals("Failure") && (error = (Object[])response.get("ErrorDescription"))[0].equals("VLAN_TAG_INVALID")) {
            throw new Types.VlanTagInvalid((String)error[1]);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Task enableHaAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.pool.enable_ha";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static void enableHa(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.enable_ha";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static Task disableHaAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.pool.disable_ha";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static void disableHa(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.disable_ha";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static Task syncDatabaseAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.pool.sync_database";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static void syncDatabase(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.sync_database";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static Task designateNewMasterAsync(Connection c, Host host) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.pool.designate_new_master";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(host)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static void designateNewMaster(Connection c, Host host) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.designate_new_master";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(host)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static Set<Pool> getAll(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.get_all";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfPool(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Map<Pool, Record> getAllRecords(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "pool.get_all_records";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfPoolPoolRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Record
    implements Types.Record {
        public String uuid;
        public String nameLabel;
        public String nameDescription;
        public Host master;
        public SR defaultSR;
        public SR suspendImageSR;
        public SR crashDumpSR;
        public Map<String, String> otherConfig;

        public String toString() {
            StringWriter writer = new StringWriter();
            PrintWriter print = new PrintWriter(writer);
            print.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            print.printf("%1$20s: %2$s\n", "nameLabel", this.nameLabel);
            print.printf("%1$20s: %2$s\n", "nameDescription", this.nameDescription);
            print.printf("%1$20s: %2$s\n", "master", this.master);
            print.printf("%1$20s: %2$s\n", "defaultSR", this.defaultSR);
            print.printf("%1$20s: %2$s\n", "suspendImageSR", this.suspendImageSR);
            print.printf("%1$20s: %2$s\n", "crashDumpSR", this.crashDumpSR);
            print.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            return writer.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("uuid", this.uuid == null ? "" : this.uuid);
            map.put("name_label", this.nameLabel == null ? "" : this.nameLabel);
            map.put("name_description", this.nameDescription == null ? "" : this.nameDescription);
            map.put("master", this.master == null ? Host.getInstFromRef("OpaqueRef:NULL") : this.master);
            map.put("default_SR", this.defaultSR == null ? SR.getInstFromRef("OpaqueRef:NULL") : this.defaultSR);
            map.put("suspend_image_SR", this.suspendImageSR == null ? SR.getInstFromRef("OpaqueRef:NULL") : this.suspendImageSR);
            map.put("crash_dump_SR", this.crashDumpSR == null ? SR.getInstFromRef("OpaqueRef:NULL") : this.crashDumpSR);
            map.put("other_config", this.otherConfig == null ? new HashMap() : this.otherConfig);
            return map;
        }
    }
}

