/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.xen;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.HostCpu;
import com.xensource.xenapi.PBD;
import com.xensource.xenapi.PIF;
import com.xensource.xenapi.SR;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.xen.XenUtil;
import org.hyperic.hq.product.PlatformServiceDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;

public class XenHostServiceDetector
extends PlatformServiceDetector {
    private static final Log _log = LogFactory.getLog((String)XenHostServiceDetector.class.getName());

    public List getServerResources(ConfigResponse config) {
        if (config.getValue("url") == null) {
            return null;
        }
        return super.getServerResources(config);
    }

    protected ServerResource getServer(ConfigResponse config) {
        ServerResource server = this.createServerResource("/");
        String name = XenHostServiceDetector.getPlatformName();
        String type = config.getValue("platform.type");
        server.setName(name + " " + type);
        server.setIdentifier(type);
        server.setProductConfig();
        server.setMeasurementConfig();
        _log.debug((Object)("Created server=" + server.getName()));
        return server;
    }

    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        Properties props = serverConfig.toProperties();
        Connection conn = XenUtil.connect(props);
        Host host = XenUtil.getHost(conn, props);
        try {
            for (PBD pbd : host.getPBDs(conn)) {
                Map<String, String> dconfig = pbd.getDeviceConfig(conn);
                String device = dconfig.get("device");
                if (device == null || "true".equals(dconfig.get("legacy_mode"))) continue;
                String uuid = pbd.getUuid(conn);
                ConfigResponse config = new ConfigResponse();
                config.setValue("service.uuid", uuid);
                SR sr = pbd.getSR(conn);
                String type = sr.getType(conn);
                ConfigResponse cprops = new ConfigResponse();
                cprops.setValue("type", type);
                ServiceResource service = this.createServiceResource("Storage");
                service.setServiceName("Storage " + device);
                service.setProductConfig(config);
                service.setMeasurementConfig();
                service.setCustomProperties(cprops);
                service.setDescription(sr.getNameLabel(conn));
                services.add(service);
            }
        }
        catch (Exception e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            for (PIF pif : host.getPIFs(conn)) {
                ConfigResponse config = new ConfigResponse();
                String uuid = pif.getUuid(conn);
                config.setValue("service.uuid", uuid);
                String device = pif.getDevice(conn);
                ConfigResponse cprops = new ConfigResponse();
                cprops.setValue("mac", pif.getMAC(conn));
                cprops.setValue("mtu", pif.getMTU(conn).longValue());
                ServiceResource service = this.createServiceResource("NIC");
                service.setServiceName("NIC " + device);
                service.setProductConfig(config);
                service.setMeasurementConfig();
                service.setCustomProperties(cprops);
                services.add(service);
            }
        }
        catch (Exception e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            for (HostCpu cpu : host.getHostCPUs(conn)) {
                HostCpu.Record record = cpu.getRecord(conn);
                ConfigResponse config = new ConfigResponse();
                config.setValue("service.uuid", record.uuid);
                ConfigResponse cprops = new ConfigResponse();
                cprops.setValue("vendor", record.vendor);
                cprops.setValue("model", record.modelname);
                cprops.setValue("speed", record.speed + "Ghz");
                ServiceResource service = this.createServiceResource("CPU");
                service.setServiceName("CPU " + record.number);
                service.setProductConfig(config);
                service.setMeasurementConfig();
                service.setCustomProperties(cprops);
                services.add(service);
            }
        }
        catch (Exception e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
        }
        return services;
    }
}

