/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.NamingException;
import org.hyperic.hq.plugin.weblogic.WeblogicAuth;
import org.hyperic.hq.plugin.weblogic.WeblogicProductPlugin;
import org.hyperic.hq.plugin.weblogic.jmx.AttributeGetter;
import org.hyperic.hq.plugin.weblogic.jmx.ObjectNameCache;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicAttributes;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;
import weblogic.jndi.Environment;
import weblogic.management.MBeanHome;
import weblogic.management.RemoteMBeanServer;

public class WeblogicUtil {
    private static final boolean useAttrGetter = true;
    private static final String MBEAN_HOME = "MBeanHome";
    private static final String[] ADMIN_MBEAN_TYPES = new String[]{"Application", "WebAppComponent", "EJBComponent"};
    private static final HashMap ADMIN_MBEANS;
    private static HashMap serverCache;
    private static HashMap managedServerConnectionCache;

    static Object getRemoteMBeanValue(Metric metric) throws MetricNotFoundException, MetricUnreachableException, PluginException {
        return WeblogicUtil.getRemoteMBeanValue(metric, metric.getAttributeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object getRemoteMBeanValue(Metric metric, String attributeName) throws MetricNotFoundException, MetricUnreachableException, PluginException {
        Object value;
        ObjectName objName;
        try {
            objName = ObjectNameCache.getInstance(metric.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            String msg = "Malformed ObjectName '" + metric.getObjectName() + "'";
            throw new MetricInvalidException(msg, (Throwable)e);
        }
        Properties props = metric.getProperties();
        Properties objProps = metric.getObjectProperties();
        String home = props.getProperty(MBEAN_HOME);
        if (home == null) {
            String type = objProps.getProperty("Type");
            home = ADMIN_MBEANS.get(type) == Boolean.TRUE ? "weblogic.management.adminhome" : "weblogic.management.home.localhome";
            props.setProperty(MBEAN_HOME, home);
            metric.setPropString(metric.getPropString() + "," + MBEAN_HOME + "=" + home);
        }
        RemoteMBeanServer mServer = null;
        boolean cached = true;
        boolean retry = false;
        String cacheKey = metric.getPropString();
        HashMap hashMap = serverCache;
        synchronized (hashMap) {
            mServer = (RemoteMBeanServer)serverCache.get(cacheKey);
        }
        if (mServer == null) {
            cached = false;
            mServer = WeblogicUtil.getMBeanServer(metric);
            hashMap = serverCache;
            synchronized (hashMap) {
                serverCache.put(cacheKey, mServer);
            }
        }
        RemoteMBeanServer remoteMBeanServer = mServer;
        synchronized (remoteMBeanServer) {
            try {
                AttributeGetter getter = AttributeGetter.getInstance(WeblogicAttributes.instance, objName);
                if (getter != null) {
                    return getter.getAttribute((MBeanServer)mServer, attributeName);
                }
                value = mServer.getAttribute(objName, attributeName);
            }
            catch (MBeanException e) {
                String msg = "MBeanException: " + e.getMessage();
                throw new PluginException(msg, (Throwable)e);
            }
            catch (AttributeNotFoundException e) {
                String msg = "Attribute '" + attributeName + "' " + "not found for '" + objName + "'";
                throw new MetricNotFoundException(msg, (Throwable)e);
            }
            catch (InstanceNotFoundException e) {
                String msg = "MBean '" + objName + "' not found";
                throw new MetricNotFoundException(msg, (Throwable)e);
            }
            catch (ReflectionException e) {
                String msg = "ReflectionException: " + e.getMessage();
                throw new PluginException(msg, (Throwable)e);
            }
            catch (Exception e) {
                if (cached) {
                    serverCache.remove(cacheKey);
                    WeblogicAuth.clearCache();
                    value = null;
                    retry = true;
                }
                String msg = "Unknown failure: " + e.getMessage();
                throw new PluginException(msg, (Throwable)e);
            }
        }
        if (retry) {
            return WeblogicUtil.getRemoteMBeanValue(metric);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JMXConnector getManagedServerConnection(Metric metric) throws PluginException {
        String cacheKey = metric.getPropString();
        JMXConnector mServer = null;
        HashMap hashMap = managedServerConnectionCache;
        synchronized (hashMap) {
            mServer = (JMXConnector)managedServerConnectionCache.get(cacheKey);
            if (mServer != null) {
                try {
                    mServer.getMBeanServerConnection().getDefaultDomain();
                }
                catch (Exception e) {
                    mServer = null;
                }
            }
            if (mServer == null) {
                mServer = WeblogicUtil.getManagedServerConnection(metric.getProperties());
                managedServerConnectionCache.put(cacheKey, mServer);
            }
        }
        return mServer;
    }

    public static JMXConnector getManagedServerConnection(Properties props) throws PluginException {
        String adminUrl = props.getProperty("admin.url");
        String url = props.getProperty("server.url", adminUrl);
        String jndiUrl = "service:jmx:" + url + "/jndi/weblogic.management.mbeanservers.runtime";
        try {
            JMXServiceURL serviceURL = new JMXServiceURL(jndiUrl);
            Hashtable<String, String> h = new Hashtable<String, String>();
            h.put("java.naming.security.principal", props.getProperty("admin.username"));
            h.put("java.naming.security.credentials", props.getProperty("admin.password", ""));
            h.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
            JMXConnector connector = JMXConnectorFactory.connect(serviceURL, h);
            return connector;
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    public static RemoteMBeanServer getMBeanServer(Properties props) throws MetricNotFoundException, MetricUnreachableException, PluginException {
        MBeanHome home;
        Context ctx;
        Environment env = new Environment();
        String adminUrl = props.getProperty("admin.url");
        String url = props.getProperty("server.url", adminUrl);
        env.setProviderUrl(url);
        env.setSecurityPrincipal(props.getProperty("admin.username"));
        env.setSecurityCredentials((Object)props.getProperty("admin.password", ""));
        if (WeblogicProductPlugin.useSSL2Ways() && WeblogicProductPlugin.getSSL2WaysCert() != null && WeblogicProductPlugin.getSSL2WaysKey() != null) {
            try {
                InputStream[] chain = new InputStream[]{new FileInputStream(new File(WeblogicProductPlugin.getSSL2WaysKey())), new FileInputStream(new File(WeblogicProductPlugin.getSSL2WaysCert()))};
                env.setSSLClientCertificate(chain);
                env.setSSLClientKeyPassword(WeblogicProductPlugin.getSSL2WaysKeyPass());
            }
            catch (IOException e) {
                throw new MetricUnreachableException("Bad SSL2Ways config", (Throwable)e);
            }
        }
        try {
            ctx = env.getInitialContext();
        }
        catch (NamingException e) {
            String msg = "Failed to connect to MBeanServer: " + url;
            String cause = e.getMessage();
            String reason = cause != null ? cause : "invalid URL or credentials";
            msg = msg + " (" + reason + ")";
            throw new MetricUnreachableException(msg, (Throwable)e);
        }
        String mbeanHome = props.getProperty(MBEAN_HOME, "weblogic.management.home.localhome");
        try {
            home = (MBeanHome)ctx.lookup(mbeanHome);
        }
        catch (NamingException e) {
            String msg = "Failed to contact MBeanServer: " + e.getMessage();
            throw new MetricUnreachableException(msg, (Throwable)e);
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                String msg = "Failed to close MBeanServer context: " + e.getMessage();
                throw new PluginException(msg, (Throwable)e);
            }
        }
        try {
            return home.getMBeanServer();
        }
        catch (SecurityException e) {
            String doc = "http://e-docs.bea.com/wls/docs70/secmanage/domain.html#1171534";
            String msg = "SecurityException getting MBeanServer (jaas=" + WeblogicProductPlugin.useJAAS() + "): " + e.getMessage() + "\n" + "Likely cause: domain credential mismatch\n" + "See: " + "http://e-docs.bea.com/wls/docs70/secmanage/domain.html#1171534";
            throw new PluginException(msg);
        }
    }

    static RemoteMBeanServer getMBeanServer(Metric metric) throws MetricNotFoundException, MetricUnreachableException, PluginException {
        return WeblogicUtil.getMBeanServer(metric.getProperties());
    }

    static RemoteMBeanServer getMBeanServer(ConfigResponse config) throws MetricNotFoundException, MetricUnreachableException, PluginException {
        return WeblogicUtil.getMBeanServer(config.toProperties());
    }

    static Object invoke(Metric metric, String method) throws MetricNotFoundException, MetricUnreachableException, PluginException {
        return WeblogicUtil.invoke(metric, method, new Object[0], new String[0]);
    }

    static Object invoke(Metric metric, String method, Object[] args, String[] sig) throws MetricNotFoundException, MetricUnreachableException, PluginException {
        ObjectName obj;
        RemoteMBeanServer mServer;
        try {
            mServer = WeblogicUtil.getMBeanServer(metric);
        }
        catch (PluginException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        try {
            obj = ObjectNameCache.getInstance(metric.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            throw new MetricInvalidException(e.getMessage());
        }
        try {
            return mServer.invoke(obj, method, args, sig);
        }
        catch (InstanceNotFoundException e) {
            throw new MetricInvalidException(e.getMessage());
        }
        catch (MBeanException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        catch (ReflectionException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
    }

    static double convertStateVal(Object state) {
        if (state instanceof Integer) {
            return WeblogicUtil.convertStateVal((Integer)state);
        }
        if (state instanceof Boolean) {
            boolean deployed = (Boolean)state;
            return deployed ? 1.0 : 0.0;
        }
        if (state instanceof String) {
            if ("DEPLOYED".equals(state)) {
                return 1.0;
            }
            if ("running".equalsIgnoreCase((String)state)) {
                return 1.0;
            }
            return 1.0;
        }
        return 2.0;
    }

    static double convertStateVal(Integer state) {
        switch (state) {
            case 2: {
                return 1.0;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 0.0;
            }
        }
        return 2.0;
    }

    static {
        HashMap<String, Boolean> beans = new HashMap<String, Boolean>();
        for (int i = 0; i < ADMIN_MBEAN_TYPES.length; ++i) {
            beans.put(ADMIN_MBEAN_TYPES[i], Boolean.TRUE);
        }
        ADMIN_MBEANS = beans;
        serverCache = new HashMap();
        managedServerConnectionCache = new HashMap();
    }
}

