/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic.config;

import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.weblogic.WeblogicConfigTrackPlugin;
import org.hyperic.hq.plugin.weblogic.WeblogicUtil;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.hq.product.TypeInfo;
import weblogic.management.RemoteMBeanServer;
import weblogic.management.RemoteNotificationListener;

public class WeblogicAttributeChangeListener
implements RemoteNotificationListener {
    private static final String[] SERVER_MBEANS = new String[]{"%domain%:Location=%server%,Name=%server%,ServerConfig=%server%,Type=SSLConfig", "%domain%:Location=%server%,Name=%server%,Type=ServerConfig"};
    private static final String[] JDBC_MBEANS = new String[]{"%domain%:Name=%jdbc.conn%,Type=JDBCConnectionPool"};
    private WeblogicConfigTrackPlugin plugin;
    private Properties props;
    private String[] mbeans;
    protected static Log log = LogFactory.getLog((String)WeblogicAttributeChangeListener.class.getName());

    private WeblogicAttributeChangeListener() {
    }

    public WeblogicAttributeChangeListener(WeblogicConfigTrackPlugin plugin) {
        this.plugin = plugin;
        this.props = plugin.getConfig().toProperties();
    }

    public static WeblogicAttributeChangeListener getInstance(WeblogicConfigTrackPlugin plugin) {
        WeblogicAttributeChangeListener listener = new WeblogicAttributeChangeListener(plugin);
        TypeInfo type = plugin.getTypeInfo();
        if (type.isServer("Weblogic Admin") || type.isServer("Weblogic")) {
            listener.mbeans = SERVER_MBEANS;
        } else if (type.isService("JDBC Connection Pool")) {
            listener.mbeans = JDBC_MBEANS;
        } else {
            throw new IllegalArgumentException(type.getName());
        }
        return listener;
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public Object getHandback() {
        return null;
    }

    public void add() throws PluginException {
        RemoteMBeanServer mServer;
        try {
            mServer = WeblogicUtil.getMBeanServer(this.props);
        }
        catch (MetricUnreachableException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        catch (MetricNotFoundException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        String[] mbeans = this.translate(this.mbeans);
        for (int i = 0; i < mbeans.length; ++i) {
            ObjectName obj;
            try {
                obj = new ObjectName(mbeans[i]);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            try {
                mServer.addNotificationListener(obj, (NotificationListener)((Object)this), this.getFilter(), this.getHandback());
                log.info((Object)("Added listener for: " + mbeans[i]));
                continue;
            }
            catch (InstanceNotFoundException e) {
                throw new PluginException("InstanceNotFound: '" + mbeans[i] + "'", (Throwable)e);
            }
        }
    }

    public void remove() throws PluginException {
        RemoteMBeanServer mServer;
        try {
            mServer = WeblogicUtil.getMBeanServer(this.props);
        }
        catch (MetricUnreachableException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        catch (MetricNotFoundException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        String[] mbeans = this.translate(this.mbeans);
        for (int i = 0; i < mbeans.length; ++i) {
            ObjectName obj;
            try {
                obj = new ObjectName(mbeans[i]);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            try {
                mServer.removeNotificationListener(obj, (NotificationListener)((Object)this));
                log.info((Object)("Removed listener for: " + mbeans[i]));
                continue;
            }
            catch (InstanceNotFoundException e) {
                throw new PluginException(mbeans[i] + ": " + e.getMessage(), (Throwable)e);
            }
            catch (ListenerNotFoundException e) {
                log.warn((Object)(mbeans[i] + ": " + e.getMessage()));
            }
        }
    }

    public String[] translate(String[] mbeans) {
        String[] translated = new String[mbeans.length];
        for (int i = 0; i < mbeans.length; ++i) {
            translated[i] = Metric.translate((String)mbeans[i], (Properties)this.props);
        }
        return translated;
    }

    public synchronized void handleNotification(Notification notification, Object handback) {
        if (!(notification instanceof AttributeChangeNotification)) {
            return;
        }
        AttributeChangeNotification change = (AttributeChangeNotification)notification;
        String msg = change.getAttributeName() + " changed from " + change.getOldValue() + " to " + change.getNewValue();
        log.info((Object)msg);
        TrackEvent event = new TrackEvent(this.plugin.getName(), System.currentTimeMillis(), 6, change.getSource().toString(), msg);
        this.plugin.getManager().reportEvent(event);
    }
}

