/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.weblogic.jmx.EntityBeanQuery;
import org.hyperic.hq.plugin.weblogic.jmx.MessageDrivenBeanQuery;
import org.hyperic.hq.plugin.weblogic.jmx.ServerQuery;
import org.hyperic.hq.plugin.weblogic.jmx.ServiceQuery;
import org.hyperic.hq.plugin.weblogic.jmx.StatefulBeanQuery;
import org.hyperic.hq.plugin.weblogic.jmx.StatelessBeanQuery;
import org.hyperic.hq.plugin.weblogic.jmx.WebAppComponentQuery;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicQuery;

public class ApplicationQuery
extends ServiceQuery {
    private static final Log log = LogFactory.getLog(ApplicationQuery.class);
    public static final String MBEAN_TYPE = "ApplicationRuntime";
    public static final String MBEAN_TYPE_61 = "ApplicationConfig";
    private static final String ATTR_EAR = "EAR";
    private static final String[] EAR_ATTRS = new String[]{"EAR"};
    private static final WeblogicQuery[] COMPONENTS = new WeblogicQuery[]{new EntityBeanQuery(), new MessageDrivenBeanQuery(), new StatelessBeanQuery(), new StatefulBeanQuery(), new WebAppComponentQuery()};
    private String mbeanName;

    public String[] getAttributeNames() {
        return EAR_ATTRS;
    }

    public WeblogicQuery[] getChildQueries() {
        return COMPONENTS;
    }

    public String getMBeanType() {
        if (this.isServer61()) {
            return MBEAN_TYPE_61;
        }
        return MBEAN_TYPE;
    }

    public String getMBeanNameProperty() {
        return this.mbeanName;
    }

    public String getResourceType() {
        return "Application";
    }

    public String getPropertyName() {
        return "application";
    }

    public boolean isEAR() {
        return "true".equalsIgnoreCase(this.getAttribute(ATTR_EAR));
    }

    public boolean getAttributes(MBeanServer mServer, ObjectName name) {
        String appName = name.getKeyProperty("Name");
        ServerQuery server = (ServerQuery)this.getParent();
        String serverName = server.getName();
        this.mbeanName = appName;
        if (appName.startsWith(serverName) && appName.length() > serverName.length() + 1) {
            appName = appName.substring(serverName.length() + 1);
        }
        if (appName.startsWith(serverName) && appName.length() > serverName.length()) {
            appName = appName.substring(serverName.length());
        }
        log.debug((Object)("[getAttributes] mbeanName = '" + this.mbeanName + "' => '" + appName + "'"));
        if (server.getDiscover().isInternalApp(appName)) {
            log.debug((Object)(appName + " is a internal Application"));
            return false;
        }
        this.setName(appName);
        super.getAttributes(mServer, name);
        return true;
    }
}

