/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic.jmx;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.weblogic.WeblogicDetector;
import org.hyperic.hq.plugin.weblogic.WeblogicLogFileTrackPlugin;
import org.hyperic.hq.plugin.weblogic.jmx.BaseServerQuery;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicDiscover;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicQuery;
import org.hyperic.hq.product.TypeBuilder;

public class ServerQuery
extends BaseServerQuery
implements Comparator {
    private static final Log log = LogFactory.getLog(ServerQuery.class);
    private WeblogicDiscover discover;
    private String url;
    private boolean isAdmin = false;
    private boolean isRunning = true;
    private String jvmType = "JVMRuntime";
    private File cwd;
    private String wlsVersion;
    public static final String MBEAN_TYPE = "Server";
    public static final String PROTOCOL_T3 = "t3";
    public static final String PROTOCOL_T3S = "t3s";
    public static final String ATTR_ADMIN_PORT = "AdministrationPort";
    public static final String ATTR_ADMIN_OVERRIDE_PORT = "AdministrationPortAfterOverride";
    public static final String ATTR_ADMIN_PORT_ENABLED = "AdministrationPortEnabled";
    public static final String ATTR_JVM_RUNTIME = "JVMRuntime";
    private static final String[] SERVER_ATTRS = new String[]{"ListenAddress", "ListenPort", "DefaultProtocol", "Notes", "ServerVersion", "AdministrationPort", "AdministrationPortEnabled"};
    private static final String[] CPROP_ATTRS = new String[]{"ServerVersion", "JavaVersion", "JavaVendor"};
    private static final String[] JVM_RUNTIME_ATTRS = new String[]{"JavaVersion", "JavaVendor"};
    private static final String[] SERVER_RUNTIME_ATTRS = new String[]{"WeblogicVersion", "ListenAddress", "CurrentDirectory", "JVMRuntime", "SSLListenPort", "AdminServer"};
    private static final String[] LOG_ATTRS = new String[]{"FileName"};

    public WeblogicDiscover getDiscover() {
        return this.discover;
    }

    public void setDiscover(WeblogicDiscover discover) {
        this.discover = discover;
    }

    public WeblogicQuery cloneInstance() {
        ServerQuery query = (ServerQuery)super.cloneInstance();
        query.discover = this.discover;
        return query;
    }

    private boolean isAdminPortEnabled() {
        return "true".equals(this.getAttribute(ATTR_ADMIN_PORT_ENABLED));
    }

    public String getListenPort() {
        if (this.isAdminPortEnabled()) {
            String oPort = this.getAttribute(ATTR_ADMIN_OVERRIDE_PORT);
            if ("0".equals(oPort) || oPort == null) {
                return this.getAttribute(ATTR_ADMIN_PORT);
            }
            return oPort;
        }
        if (this.isAdminSSL()) {
            return this.getSSLListenPort();
        }
        return super.getListenPort();
    }

    public String getProtocol() {
        return this.isAdminSSL() ? PROTOCOL_T3S : this.getAttribute("DefaultProtocol");
    }

    public boolean isAdminSSL() {
        return this.discover.isAdminSSL();
    }

    private void configureUrl() {
        String address = this.getListenAddress();
        int idx = address.indexOf("/");
        if (idx != -1) {
            address = address.substring(idx + 1);
            this.attrs.put("ListenAddress", address);
        }
        this.url = this.getProtocol() + "://" + address + ":" + this.getListenPort();
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isValidVersion(String version) {
        if (version == null) {
            return false;
        }
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return false;
        }
        return true;
    }

    private String getWeblogicVersion() {
        String version = this.getAttribute("WeblogicVersion");
        if (version == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(version);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (!this.isValidVersion(s)) continue;
            return s;
        }
        return null;
    }

    private ObjectName getServerRuntime() {
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        attributes.put("Type", "ServerRuntime");
        attributes.put("Name", this.getName());
        attributes.put("Location", this.getName());
        try {
            return new ObjectName(this.discover.getDomain(), attributes);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private ObjectName getJVMRuntime() {
        String jvm = this.getAttribute(ATTR_JVM_RUNTIME);
        if (jvm == null) {
            return null;
        }
        try {
            return new ObjectName(jvm);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private ObjectName getSSL() {
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        attributes.put("Type", "SSL");
        attributes.put("Name", this.getName());
        attributes.put(MBEAN_TYPE, this.getName());
        try {
            return new ObjectName(this.discover.getDomain(), attributes);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void getSSLAttrs(MBeanServer mServer) {
        try {
            Object port = mServer.getAttribute(this.getSSL(), "ListenPort");
            this.attrs.put("SSLListenPort", port.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ObjectName getLogMBean() {
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        attributes.put("Name", this.getName());
        attributes.put("Location", this.getName());
        attributes.put("ServerConfig", this.getName());
        attributes.put("Type", "LogConfig");
        try {
            return new ObjectName(this.discover.getDomain(), attributes);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public boolean getAttributes(MBeanServer mServer, ObjectName name) {
        this.setName(name.getKeyProperty("Name"));
        this.setVersion(this.getDiscover().getVersion());
        if (!super.getAttributes(mServer, name, SERVER_ATTRS)) {
            return false;
        }
        if (this.isAdminPortEnabled()) {
            super.getAttributes(mServer, name, new String[]{ATTR_ADMIN_OVERRIDE_PORT});
        }
        ObjectName runtimeName = this.getServerRuntime();
        ObjectName logName = this.getLogMBean();
        boolean isAdminName = this.getName().equals(this.discover.getAdminName());
        if (isAdminName) {
            super.getAttributes(mServer, runtimeName, SERVER_RUNTIME_ATTRS);
            super.getAttributes(mServer, this.getJVMRuntime(), JVM_RUNTIME_ATTRS);
            super.getAttributes(mServer, logName, LOG_ATTRS);
            if (this.getSSLListenPort() == null) {
                this.getSSLAttrs(mServer);
            }
            this.configureUrl();
        } else {
            this.getSSLAttrs(mServer);
            this.configureUrl();
            try {
                MBeanServer nodeServer = this.discover.getMBeanServer(this.url);
                this.isRunning = super.getAttributes(nodeServer, runtimeName, SERVER_RUNTIME_ATTRS);
                if (this.isRunning) {
                    if (this.getJVMRuntime() == null) {
                        this.isRunning = false;
                    } else {
                        super.getAttributes(nodeServer, this.getJVMRuntime(), JVM_RUNTIME_ATTRS);
                    }
                    super.getAttributes(nodeServer, logName, LOG_ATTRS);
                }
                this.configureUrl();
            }
            catch (Exception e) {
                this.isRunning = false;
            }
        }
        String serverVersion = this.getAttribute("ServerVersion");
        if (this.isValidVersion(serverVersion)) {
            this.wlsVersion = serverVersion.substring(0, 3);
        } else if (serverVersion == null || serverVersion.equals("unknown")) {
            this.wlsVersion = this.getWeblogicVersion();
        }
        if (!this.isRunning) {
            return true;
        }
        this.isAdmin = isAdminName;
        File path = new File(this.getAttribute("CurrentDirectory"));
        if (path.getName().equals(".")) {
            path = path.getParentFile();
        }
        this.cwd = path;
        return true;
    }

    public String getMBeanAlias() {
        return "Location";
    }

    public String getMBeanType() {
        return MBEAN_TYPE;
    }

    public String getQualifiedName() {
        return this.discover.getDomain() + " " + this.getName();
    }

    public String getResourceType() {
        String type = this.isAdmin ? "Weblogic Admin" : "Weblogic";
        String version = this.getDiscover().getVersion();
        return TypeBuilder.composeServerTypeName((String)type, (String)version);
    }

    public String getIdentifier() {
        return this.getResourceFullName();
    }

    public String getInstallPath() {
        return new File(this.cwd, this.getName()).toString();
    }

    public File getCwd() {
        return this.cwd;
    }

    public void setCwd(File value) {
        this.cwd = value;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    protected String getControlProgram() {
        String ctl;
        if (!this.isRunning) {
            return "";
        }
        if (this.cwd.getName().equals("nodemanager")) {
            ctl = "";
        } else {
            try {
                ctl = new File(this.cwd, WeblogicDetector.NODE_START).getCanonicalPath();
            }
            catch (IOException ex) {
                ctl = new File(this.cwd, WeblogicDetector.NODE_START).getPath();
                log.debug((Object)ex);
            }
        }
        return ctl;
    }

    public void configureAdminProps(Properties props) {
        props.setProperty("admin.url", this.discover.getAdminURL());
        props.setProperty("admin.username", this.discover.getUsername());
        props.setProperty("admin.password", this.discover.getPassword());
    }

    public void configure(Properties props) {
        this.configureAdminProps(props);
        if (!this.isAdmin) {
            props.setProperty("server.url", this.url);
        }
        props.setProperty("domain", this.discover.getDomain());
        props.setProperty("server", this.getName());
        String jvmType = this.getJVMRuntime() != null ? this.getJVMRuntime().getKeyProperty("Type") : this.jvmType;
        props.setProperty("jvm.runtime", jvmType);
        String log = this.getAttribute("FileName");
        if (log != null) {
            String cur = "." + File.separator;
            if (log.startsWith(cur)) {
                log = log.substring(2);
            }
            log = this.cwd + File.separator + log;
            props.setProperty(WeblogicLogFileTrackPlugin.PROP_FILES_SERVER, log);
        }
    }

    public String[] getCustomPropertiesNames() {
        return CPROP_ATTRS;
    }

    private int getOrder(ServerQuery s) {
        if (s.isAdmin()) {
            return 1;
        }
        if (s.isRunning()) {
            return 2;
        }
        return 3;
    }

    public int compare(Object s1, Object s2) {
        return this.getOrder((ServerQuery)s1) - this.getOrder((ServerQuery)s2);
    }

    public void sort(List servers) {
        Collections.sort(servers, this);
    }
}

