/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic.jmx;

import java.io.File;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hyperic.hq.plugin.weblogic.WeblogicProductPlugin;
import org.hyperic.hq.plugin.weblogic.jmx.ComponentQuery;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicDiscover;
import org.hyperic.hq.product.RtPlugin;
import weblogic.management.descriptors.WebDescriptorMBean;
import weblogic.management.descriptors.webapp.FilterMBean;
import weblogic.management.descriptors.webapp.ParameterMBean;

public class WebAppComponentQuery
extends ComponentQuery {
    public static final String MBEAN_TYPE = "WebAppComponentRuntime";
    private static final String[] ATTRS = new String[]{"URI"};
    private static final String[] RUNTIME_ATTRS = new String[]{"ContextRoot"};
    private String rtLogDir = null;
    private Properties rtConfig = null;
    private String webappDir = ".";

    public String getMBeanType() {
        return MBEAN_TYPE;
    }

    public String getResourceType() {
        return "Webapp";
    }

    public String getPropertyName() {
        return "webapp";
    }

    protected String getNamePrefix() {
        return this.webappPrefix;
    }

    public String[] getCustomPropertiesNames() {
        return RUNTIME_ATTRS;
    }

    public Properties getResponseTimeConfig() {
        if (this.rtLogDir == null) {
            return super.getResponseTimeConfig();
        }
        if (this.rtConfig != null) {
            return this.rtConfig;
        }
        this.rtConfig = new Properties();
        String rtLogFile = this.getName() + "_HQResponseTime.log";
        this.rtConfig.setProperty(RtPlugin.CONFIG_LOGMASK, rtLogFile);
        this.rtConfig.setProperty(RtPlugin.CONFIG_LOGDIR, this.rtLogDir);
        this.rtConfig.setProperty(RtPlugin.CONFIG_INTERVAL, "60");
        return this.rtConfig;
    }

    public boolean getAttributes(MBeanServer mServer, ObjectName name) {
        String path;
        ObjectName configMBean;
        if (!super.getAttributes(mServer, name)) {
            return false;
        }
        super.getAttributes(mServer, name, RUNTIME_ATTRS);
        if (!WeblogicProductPlugin.autoRT()) {
            return true;
        }
        String config = name.getDomain() + ":" + "Application=" + this.getParent().getName() + "," + "Name=" + this.getName() + "," + "Type=WebAppComponent";
        try {
            configMBean = new ObjectName(config);
        }
        catch (MalformedObjectNameException e) {
            WeblogicDiscover.getLog().error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
        try {
            WebDescriptorMBean descriptor = (WebDescriptorMBean)mServer.invoke(configMBean, "findOrCreateWebDescriptor", new Object[0], new String[0]);
            FilterMBean[] filters = descriptor.getWebAppDescriptor().getFilters();
            block4: for (int i = 0; i < filters.length; ++i) {
                ParameterMBean[] params = filters[i].getInitParams();
                for (int j = 0; j < params.length; ++j) {
                    String pName = params[j].getParamName();
                    if (!pName.equals("responseTimeLogDir")) continue;
                    this.rtLogDir = params[j].getParamValue();
                    continue block4;
                }
            }
        }
        catch (Throwable e) {
            WeblogicDiscover.getLog().debug((Object)("RT config lookup failed: " + e));
            return true;
        }
        if (WeblogicDiscover.getLog().isDebugEnabled()) {
            WeblogicDiscover.getLog().debug((Object)(this.getName() + " RT config=" + this.getResponseTimeConfig()));
        }
        if ((path = this.getParent().getAttribute("Path")) != null) {
            super.getAttributes(mServer, configMBean, ATTRS);
            String uri = this.getAttribute(ATTRS[0]);
            if (uri != null) {
                this.webappDir = path + File.separator + uri;
            }
        }
        return true;
    }

    public Properties getResourceConfig() {
        Properties props = super.getResourceConfig();
        props.setProperty("webapp.dir", this.webappDir);
        return props;
    }
}

