/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.sqlquery;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.JDBCMeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.EnumerationConfigOption;

public class SQLQueryMeasurementPlugin
extends JDBCMeasurementPlugin {
    private final Log _log = LogFactory.getLog(SQLQueryMeasurementPlugin.class);
    private static final String DOMAIN = "sql";
    private static final String PROP_DRIVER = "jdbcDriver";
    private static final String EXEC_TIME_ATTR = "QueryExecTime";
    private static final String PROP_ORACLE_USER = "user";
    private static final String PROP_ORACLE_PASSWORD = "password";
    private static final String PROP_ORACLE_READ_TIMEOUT = "oracle.jdbc.ReadTimeout";
    private static final int TIMEOUT_VALUE = 60000;
    private static final String ORACLE_JDBC_URL = "jdbc:oracle";
    private static final String MYSQL_JDBC_URL = "jdbc:mysql";
    private String config;
    private boolean isProxy = false;
    private static Map loadedDrivers = new HashMap();
    private static Map availableDrivers;

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        if (this.getName().equals(DOMAIN)) {
            this.isProxy = true;
            this.config = ":" + this.getProperties().getProperty("template-config");
        } else if (!this.getManager().isRegistered(DOMAIN)) {
            this.getLog().info((Object)"Registered proxy for domain: sql");
            this.getManager().createPlugin(DOMAIN, (GenericPlugin)this);
        }
    }

    public String translate(String template, ConfigResponse config) {
        if (this.isProxy && !template.endsWith(this.config)) {
            template = template + this.config;
        }
        return super.translate(template, config);
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigSchema schema = super.getConfigSchema(info, config);
        ConfigOption defopt = schema.getOption(PROP_DRIVER);
        EnumerationConfigOption option = new EnumerationConfigOption(defopt.getName(), defopt.getDescription(), defopt.getDefault(), this.getDriverNames());
        schema.addOption((ConfigOption)option);
        return schema;
    }

    private Map getAvailableDrivers() {
        if (availableDrivers != null) {
            return availableDrivers;
        }
        HashMap<String, HashMap<String, String>> drivers = new HashMap<String, HashMap<String, String>>();
        for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            int ix = key.indexOf(46);
            if (ix == -1) continue;
            String name = key.substring(0, ix);
            String prop = key.substring(ix + 1);
            Map<String, String> driver = (Map)drivers.get(name);
            if (driver == null) {
                driver = new HashMap<String, String>();
                drivers.put(name, (HashMap<String, String>)driver);
            }
            driver.put(prop, val);
        }
        availableDrivers = new HashMap(drivers.size());
        for (Map<String, String> driver : drivers.values()) {
            String name = (String)driver.get(PROP_DRIVER);
            availableDrivers.put(name, driver);
        }
        return availableDrivers;
    }

    private String[] getDriverNames() {
        Map drivers = this.getAvailableDrivers();
        Object[] names = drivers.keySet().toArray(new String[0]);
        Arrays.sort(names);
        return names;
    }

    private String encodeHTML(String val) {
        val = StringUtil.replace((String)val, (String)"<", (String)"&lt;");
        val = StringUtil.replace((String)val, (String)">", (String)"&gt;");
        return val;
    }

    private void driverItem(StringBuffer help, String key, String val) {
        help.append("<p><b>").append(key).append("</b><br>");
        help.append(val).append("</p>\n");
    }

    private String href(String url) {
        return "<a href=\"" + url + "\">" + url + "</a>";
    }

    private String included(Map driver) {
        if ("true".equals(driver.get("included"))) {
            return "<img src=\"/images/icon_available_green.gif\"> This driver is included with HQ";
        }
        return "<img src=\"/images/icon_available_yellow.gif\"> This driver is not included with HQ.  Copy required files to the agent pdk/lib/jdbc/ directory";
    }

    public String getHelp(TypeInfo info, Map props) {
        StringBuffer help = new StringBuffer();
        Map drivers = this.getAvailableDrivers();
        String[] names = this.getDriverNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Map driver = (Map)drivers.get(name);
            String driverName = (String)driver.get(PROP_DRIVER);
            if (driverName == null) continue;
            String title = (String)driver.get("name");
            help.append("<hr><p>\n");
            help.append("<h3>").append(title).append("</h3>\n");
            help.append(this.included(driver));
            this.driverItem(help, "URL Format", this.encodeHTML((String)driver.get("jdbcUrl")));
            this.driverItem(help, "Required File(s)", (String)driver.get("files"));
            this.driverItem(help, "Driver Class", driverName);
            this.driverItem(help, "More information and download", this.href((String)driver.get("download")));
            help.append("</p>\n");
        }
        return help.toString();
    }

    protected void getDriver() throws ClassNotFoundException {
    }

    private static synchronized boolean loadDriver(String driver) {
        if (loadedDrivers.get(driver) != null) {
            return true;
        }
        try {
            loadedDrivers.put(driver, Class.forName(driver));
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean loadDriver(Properties props) {
        return SQLQueryMeasurementPlugin.loadDriver(props.getProperty(PROP_DRIVER));
    }

    static Connection getConnection(Properties props) throws SQLException {
        SQLQueryMeasurementPlugin.loadDriver(props);
        String url = props.getProperty("jdbcUrl");
        String user = props.getProperty("jdbcUser");
        String pass = props.getProperty("jdbcPassword");
        return SQLQueryMeasurementPlugin.getTimedOutConnection(url, user, pass);
    }

    protected Connection getConnection(String url, String user, String password) throws SQLException {
        return SQLQueryMeasurementPlugin.getTimedOutConnection(url, user, password);
    }

    static Connection getTimedOutConnection(String url, String user, String password) throws SQLException {
        if (SQLQueryMeasurementPlugin.isOracleUrl(url)) {
            Properties info = SQLQueryMeasurementPlugin.getOracleJDBCConnectionProperties(user, password);
            return DriverManager.getConnection(url, info);
        }
        if (SQLQueryMeasurementPlugin.isMySqlUrl(url)) {
            url = SQLQueryMeasurementPlugin.getMySqlUrl(url);
        }
        return DriverManager.getConnection(url, user, password);
    }

    static boolean isOracleUrl(String url) {
        return url != null && url.toLowerCase().startsWith(ORACLE_JDBC_URL);
    }

    static boolean isMySqlUrl(String url) {
        return url != null && url.toLowerCase().startsWith(MYSQL_JDBC_URL);
    }

    private static String getMySqlUrl(String url) {
        if (url == null) {
            return url;
        }
        if (url.indexOf(63) > 0) {
            return url + "&socketTimeout=" + 60000 + "&connectTimeout=" + 60000;
        }
        return url + "?socketTimeout=" + 60000 + "&connectTimeout=" + 60000;
    }

    public static Properties getOracleJDBCConnectionProperties(String user, String password) {
        Properties info = new Properties();
        if (user != null) {
            info.put(PROP_ORACLE_USER, user);
        }
        if (password != null) {
            info.put(PROP_ORACLE_PASSWORD, password);
        }
        info.put(PROP_ORACLE_READ_TIMEOUT, new Integer(60000));
        return info;
    }

    protected String getDefaultURL() {
        return "";
    }

    protected void initQueries() {
    }

    protected String getQuery(Metric metric) {
        String query = Metric.decode((String)metric.getObjectPropString());
        SQLQueryMeasurementPlugin.loadDriver(metric.getProperties());
        return query;
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricUnreachableException, MetricInvalidException, MetricNotFoundException {
        double d;
        String attr = metric.getAttributeName();
        Properties props = metric.getProperties();
        if (!SQLQueryMeasurementPlugin.loadDriver(props)) {
            String name = props.getProperty(PROP_DRIVER);
            Map driver = (Map)this.getAvailableDrivers().get(name);
            if (driver != null) {
                String msg = "Failed to load jdbcDriver=" + name + " (missing " + driver.get("files") + "?)";
                throw new PluginException(msg);
            }
        }
        long startTime = System.currentTimeMillis();
        if (!attr.replaceAll("\\s+", "").equalsIgnoreCase("queryexectime") && !metric.isAvail()) {
            d = super.getQueryValue(metric, true);
            if (this._sqlLog != null) {
                this.getManager().reportEvent(metric, this.now(), -1, attr, this._sqlLog);
                this._sqlLog = null;
            }
        } else {
            d = super.getQueryValue(metric, false);
        }
        MetricValue val = new MetricValue(d, System.currentTimeMillis());
        long totalTime = System.currentTimeMillis() - startTime;
        if (attr.equals(EXEC_TIME_ATTR)) {
            return new MetricValue(totalTime);
        }
        return val;
    }

    private final long now() {
        return System.currentTimeMillis();
    }
}

