/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import java.io.File;
import org.hyperic.util.config.ConfigResponse;

public class WebSphereProcess {
    String installRoot;
    String serverRoot;
    private String node;
    private String server;
    private String cell;
    private long pid;

    public WebSphereProcess() {
    }

    public WebSphereProcess(ConfigResponse config) {
        this.serverRoot = config.getValue("installpath");
        this.node = config.getValue("server.node");
        this.cell = config.getValue("server.cell");
        this.server = config.getValue("server.name");
    }

    public ConfigResponse getConfig() {
        ConfigResponse res = new ConfigResponse();
        res.setValue("installpath", this.serverRoot);
        res.setValue("server.node", this.node);
        res.setValue("server.cell", this.cell);
        res.setValue("server.name", this.server);
        return res;
    }

    boolean isConfigured() {
        return this.getInstallRoot() != null && this.getServerRoot() != null && this.getNode() != null && this.getServer() != null && this.getCell() != null;
    }

    boolean isPropsConfigured() {
        return this.getInstallRoot() != null && this.getServerRoot() != null;
    }

    public String toString() {
        return "was.install.root=" + this.getInstallRoot() + ", server.root=" + this.getServerRoot() + ", server.server='" + this.getServer() + "'" + ", server.node='" + this.getNode() + "'" + ", server.cell='" + this.getCell() + "'";
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public String getNode() {
        return this.node;
    }

    public String getServer() {
        return this.server;
    }

    public String getCell() {
        return this.cell;
    }

    public void setInstallRoot(String installRoot) {
        this.installRoot = installRoot;
    }

    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setCell(String cell) {
        this.cell = cell;
    }

    public String getIdentifier() {
        return this.getServerRoot() + " " + this.getServerName();
    }

    public String getServerName() {
        String profile = this.getServerRoot().substring(this.getServerRoot().lastIndexOf(File.separator) + 1) + " ";
        return profile + this.getCell() + " " + this.getNode() + " " + this.getServer();
    }

    public long getPid() {
        return this.pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }
}

