/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.hyperic.hq.plugin.websphere.WebsphereUtil;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

public class WebsphereAppControl
extends ControlPlugin {
    private static final String[] ACTIONS = new String[]{"start", "stop"};
    private static final List COMMANDS = Arrays.asList(ACTIONS);
    private static final String APP_MANAGER_TMPL = "WebSphere:name=ApplicationManager,mbeanIdentifier=ApplicationManager,type=ApplicationManager,node=%server.node%,process=%server.name%,*";
    private String appManagerName = null;
    private Properties jmxProps;
    private static final String STRING_CLASS = String.class.getName();
    private static final String[] APP_SIG = new String[]{STRING_CLASS};

    public List getActions() {
        return COMMANDS;
    }

    private String getAppManagerName() {
        if (this.appManagerName == null) {
            this.jmxProps = this.getConfig().toProperties();
            this.appManagerName = Metric.translate((String)APP_MANAGER_TMPL, (ConfigResponse)this.getConfig());
            this.getLog().debug((Object)("appManagerName=" + this.appManagerName));
        }
        return this.appManagerName;
    }

    protected boolean isRunning() {
        return false;
    }

    public void doAction(String action) throws PluginException {
        String method;
        String appManager = this.getAppManagerName();
        String name = this.getConfig().getValue("app");
        Object[] args = new Object[]{name};
        if (action.equals("start")) {
            method = "startApplication";
        } else if (action.equals("stop")) {
            method = "stopApplication";
        } else {
            throw new PluginException("unsupported action=" + action);
        }
        this.getLog().debug((Object)("doAction: action=" + action + ", method=" + method + ", appManager=" + appManager));
        try {
            this.jmxProps.list(System.out);
            WebsphereUtil.invoke(appManager, this.jmxProps, method, args, APP_SIG);
            this.setResult(0);
        }
        catch (PluginException e) {
            this.setResult(-1);
            this.getLog().debug((Object)"doAction: invoke failed", (Throwable)e);
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        this.getLog().debug((Object)("doAction: result=" + this.getResult()));
    }
}

