/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.websphere.WebSphereProcess;
import org.hyperic.hq.plugin.websphere.WebsphereProductPlugin;
import org.hyperic.hq.plugin.websphere.jmx.WebsphereRuntimeDiscoverer;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.FileServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.RegistryServerDetector;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.util.config.ConfigResponse;

public class WebsphereDetector
extends ServerDetector
implements FileServerDetector,
RegistryServerDetector,
AutoServerDetector {
    private static final String[] METRIC_CONNECT_PROPS = new String[]{"admin.port", "admin.host"};
    protected static Log log = LogFactory.getLog((String)WebsphereDetector.class.getName());
    private static final String PTQL_QUERY = "State.Name.eq=java,Args.*.eq=com.ibm.ws.runtime.WsServer";
    private static final String SOAP_PORT_EXPR = "//serverEntries[@serverName=\"{0}\"]//specialEndpoints[@endPointName=\"SOAP_CONNECTOR_ADDRESS\"]//@port";
    private static final String SOAP_HOST_EXPR = "//serverEntries[@serverName=\"{0}\"]//specialEndpoints[@endPointName=\"SOAP_CONNECTOR_ADDRESS\"]//@host";
    protected WebsphereRuntimeDiscoverer discoverer = null;
    private String node = null;
    static final String VERSION_START = "<version>";
    static final String VERSION_END = "</version>";

    protected List discoverServices(ConfigResponse config) throws PluginException {
        if (!WebsphereProductPlugin.VALID_JVM) {
            return new ArrayList();
        }
        if (this.discoverer == null) {
            String version = this.getTypeInfo().getVersion();
            this.discoverer = new WebsphereRuntimeDiscoverer(version, this);
        }
        return this.discoverer.discoverServices(config);
    }

    protected String getProcessQuery() {
        return PTQL_QUERY;
    }

    public String getAdminHost(WebSphereProcess proc) {
        return this.getAdminHost(this.findServerIndex(proc), proc.getServer());
    }

    public String getAdminHost(File index, String serverName) {
        String host = null;
        String prop = "admin.host";
        Object[] servers = new Object[]{serverName};
        if (index != null) {
            host = this.getXPathValue(index, MessageFormat.format(SOAP_HOST_EXPR, servers));
            this.getLog().debug((Object)("Configuring admin.host=" + host + " from: " + index));
        }
        if (host == null) {
            host = this.getManager().getProperty("admin.host", "localhost");
        }
        if (host.equals("*")) {
            host = "localhost";
        }
        return host;
    }

    private File findServerIndex(WebSphereProcess proc) {
        if (proc == null) {
            return null;
        }
        File index = new File(proc.getServerRoot() + "/config/cells/" + proc.getCell() + "/nodes/" + proc.getNode() + "/serverindex.xml");
        if (!index.exists()) {
            index = null;
        }
        return index;
    }

    public String getAdminPort(WebSphereProcess proc) {
        return this.getAdminPort(this.findServerIndex(proc), proc.getServer());
    }

    public String getAdminPort(File index, String serverName) {
        String port = null;
        String prop = "admin.port";
        Object[] servers = new Object[]{serverName};
        if (index != null) {
            String query = MessageFormat.format(SOAP_PORT_EXPR, servers);
            port = this.getXPathValue(index, query);
            this.getLog().debug((Object)("Configuring admin.port=" + port + " from: " + index));
        }
        return port;
    }

    protected String getNodeName() {
        return this.node;
    }

    public final String getControlScript(String script) {
        return "bin" + File.separatorChar + script + WebsphereDetector.getScriptExtension();
    }

    public final ConfigResponse getControlConfig(WebSphereProcess proc) {
        String type = proc.getServer().equals("nodeagent") ? "Node" : "Server";
        File cs1 = new File(proc.getServerRoot(), this.getControlScript("start" + type));
        File cs2 = new File(proc.getServerRoot(), this.getControlScript("stop" + type));
        assert (cs1.exists()) : cs1.getAbsolutePath();
        assert (cs2.exists()) : cs2.getAbsolutePath();
        ConfigResponse cc = new ConfigResponse();
        cc.setValue("program.start", cs1.getAbsolutePath());
        cc.setValue("program.stop", cs2.getAbsolutePath());
        log.debug((Object)("[getControlConfig] server=" + proc.getServer()));
        log.debug((Object)("[getControlConfig] cc=" + cc));
        return cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDetector(File root) {
        String NODE_PROP = "WAS_NODE=";
        File cmdline = new File(root, "bin/setupCmdLine" + WebsphereDetector.getScriptExtension());
        FileReader reader = null;
        try {
            String line;
            reader = new FileReader(cmdline);
            BufferedReader buffer = new BufferedReader(reader);
            while ((line = buffer.readLine()) != null) {
                int ix;
                if ((line = line.trim()).length() == 0 || (ix = line.indexOf("WAS_NODE=")) == -1) continue;
                this.node = line.substring(ix + "WAS_NODE=".length());
                break;
            }
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static String getRunningInstallPath() {
        return WebsphereDetector.getRunningInstallPath(PTQL_QUERY);
    }

    static List getServerProcessList() {
        return WebsphereDetector.getServerProcessList(PTQL_QUERY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProps(File file) {
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            props.load(is);
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return props;
    }

    protected String getNodeNameFromFQDN(String fqdn) {
        int idx = fqdn.indexOf(".");
        if (idx > 0) {
            return fqdn.substring(0, idx);
        }
        return fqdn;
    }

    protected Properties getProductConfig(WebSphereProcess proc) {
        Properties productProps = new Properties();
        productProps.setProperty("admin.host", this.getAdminHost(proc));
        productProps.setProperty("admin.port", this.getAdminPort(proc));
        productProps.setProperty("server.node", proc.getNode());
        productProps.setProperty("server.cell", proc.getCell());
        productProps.setProperty("server.name", proc.getServer());
        return productProps;
    }

    protected boolean isServiceControl() {
        return WebsphereDetector.isWin32();
    }

    protected static List getServerProcessList(String query) {
        String wasProp = "-Dwas.install.root=";
        String rootProp = "-Dserver.root=";
        ArrayList<WebSphereProcess> servers = new ArrayList<WebSphereProcess>();
        long[] pids = WebsphereDetector.getPids((String)query);
        block0: for (int i = 0; i < pids.length; ++i) {
            String[] args = WebsphereDetector.getProcArgs((long)pids[i]);
            WebSphereProcess process = new WebSphereProcess();
            process.setPid(pids[i]);
            int ai = args.length;
            if (args[ai - 1].trim().equals("")) {
                --ai;
            }
            if (args.length > 3) {
                process.setServer(args[ai - 1]);
                process.setNode(args[ai - 2]);
                process.setCell(args[ai - 3]);
            }
            for (int j = 0; j < args.length; ++j) {
                String arg = args[j];
                if (arg.startsWith("-Dwas.install.root=")) {
                    process.setInstallRoot(arg.substring("-Dwas.install.root=".length(), arg.length()));
                } else if (arg.startsWith("-Dserver.root=")) {
                    process.setServerRoot(arg.substring("-Dserver.root=".length(), arg.length()));
                }
                if (!process.isPropsConfigured()) continue;
                log.debug((Object)("[getServerProcessList] process=" + process));
                servers.add(process);
                continue block0;
            }
        }
        return servers;
    }

    protected static String getRunningInstallPath(String query) {
        List servers = WebsphereDetector.getServerProcessList(query);
        if (servers.size() == 0) {
            return null;
        }
        return ((WebSphereProcess)servers.get(0)).getInstallRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getComponentVersion(File file) {
        FileReader reader = null;
        String res = "";
        try {
            String line;
            reader = new FileReader(file);
            BufferedReader buffer = new BufferedReader(reader);
            while ((line = buffer.readLine()) != null) {
                line = line.trim();
                int ix = line.indexOf(VERSION_END);
                if (!line.startsWith(VERSION_START) || ix == -1) continue;
                res = line.substring(VERSION_START.length(), ix).trim();
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Error getting the WAS version: " + e.getMessage()), (Throwable)e);
            }
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
        return res;
    }

    protected boolean isComponentVersion(File file) {
        String version = WebsphereDetector.getComponentVersion(file);
        boolean res = version.startsWith(this.getTypeInfo().getVersion());
        log.debug((Object)("version= '" + version + "' type='" + this.getTypeInfo().getVersion() + "' res=" + res));
        return res;
    }

    protected List getServerList(File serverDir, String version, WebSphereProcess proc) throws PluginException {
        String prop;
        String root;
        String uniqueFile;
        log.debug((Object)("[getServerList] (" + version + ") " + proc.getInstallRoot()));
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        if (version != null) {
            char majVersion = this.getTypeInfo().getVersion().charAt(0);
            if (version.charAt(0) != majVersion) {
                return null;
            }
        }
        if ((uniqueFile = this.getTypeProperty("UNIQUE_FILE")) != null) {
            File file = new File(proc.getInstallRoot(), uniqueFile);
            boolean exists = file.exists();
            log.debug((Object)(this.getTypeInfo().getName() + " '" + file + "'.exists()=" + exists));
            if (!exists) {
                return null;
            }
            if (file.getName().equals("WAS.product") && !this.isComponentVersion(file)) {
                return null;
            }
        }
        this.initDetector(serverDir);
        String installpath = serverDir.getAbsolutePath();
        ServerResource server = this.createServerResource(installpath);
        String type = this.getTypeInfo().getName();
        if (version != null && version.length() == 3 && !type.endsWith(version)) {
            type = type.substring(0, type.length() - 3) + version;
        }
        server.setIdentifier(proc.getIdentifier());
        server.setName(WebsphereDetector.getPlatformName() + " " + type + " " + proc.getServerName());
        ConfigResponse productConfig = new ConfigResponse((Map)this.getProductConfig(proc));
        this.populateListeningPorts(proc.getPid(), productConfig, true);
        if (WebsphereProductPlugin.isOSGi() && (root = System.getProperty(prop = "was.install.root", this.getTypeProperty(prop))) != null) {
            productConfig.setValue(prop, root);
        }
        server.setConnectProperties(METRIC_CONNECT_PROPS);
        this.setProductConfig(server, productConfig);
        server.setMeasurementConfig();
        this.setControlConfig(server, this.getControlConfig(proc));
        servers.add(server);
        log.debug((Object)("Detected " + server.getName() + " in " + serverDir));
        return servers;
    }

    public List getServerResources(ConfigResponse platformConfig, String path, RegistryKey current) throws PluginException {
        path = path.trim();
        log.debug((Object)("checking path=" + path));
        String version = current.getSubKeyName();
        if (version != null && version.length() > 3) {
            version = version.trim().substring(0, 3);
        }
        return this.getServerList(new File(path), version, null);
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList servers = new ArrayList();
        List processes = WebsphereDetector.getServerProcessList(this.getProcessQuery());
        for (int i = 0; i < processes.size(); ++i) {
            List found;
            String nodeAgentPort;
            WebSphereProcess p = (WebSphereProcess)processes.get(i);
            if (p.getServer().equals("nodeagent") || (nodeAgentPort = this.getAdminPort(this.findServerIndex(p), "nodeagent")) != null || (found = this.getServerList(new File(p.getServerRoot()), null, p)) == null) continue;
            servers.addAll(found);
        }
        return servers;
    }

    public List getServerResources(ConfigResponse platformConfig, String path) throws PluginException {
        log.debug((Object)("Looking for " + this.getName() + " in " + path));
        File jar = new File(path);
        File serverDir = jar.getParentFile().getParentFile();
        return this.getServerList(serverDir, null, null);
    }

    private void populateListeningPorts(long pid, ConfigResponse productConfig, boolean b) {
        try {
            Class<?> du = Class.forName("org.hyperic.hq.product.DetectionUtil");
            Method plp = du.getMethod("populateListeningPorts", Long.TYPE, ConfigResponse.class, Boolean.TYPE);
            plp.invoke(null, pid, productConfig, b);
        }
        catch (ClassNotFoundException ex) {
            log.debug((Object)"[populateListeningPorts] Class 'DetectionUtil' not found", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            log.debug((Object)"[populateListeningPorts] Method 'populateListeningPorts' not found", (Throwable)ex);
        }
        catch (Exception ex) {
            log.debug((Object)"[populateListeningPorts] Problem with Method 'populateListeningPorts'", (Throwable)ex);
        }
    }
}

