/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.versioncontrol.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.TreeMap;
import org.hyperic.cm.versioncontrol.util.PairOfLong;
import org.hyperic.cm.versioncontrol.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPersister
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(MapPersister.class);
    private Map<String, PairOfLong> map = new TreeMap<String, PairOfLong>();
    private String file;
    private static final String FILE_NAME = "mapfile";
    private static final long SLEEP_INERVAL = 300000L;

    MapPersister(Map<String, PairOfLong> map, String directory) {
        this.map = map;
        this.file = directory + File.separator + FILE_NAME;
    }

    public void init(boolean eraseExisting) {
        this.loadMap(eraseExisting);
    }

    @Override
    public void run() {
        try {
            while (true) {
                Thread.sleep(300000L);
                this.saveMap();
            }
        }
        catch (InterruptedException e) {
            this.saveMap();
            return;
        }
    }

    private void saveMap() {
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("persisting map start");
            }
            fos = new FileOutputStream(this.file);
            out = new ObjectOutputStream(fos);
            out.writeObject(this.map);
            out.close();
            if (log.isDebugEnabled()) {
                log.debug("persisting map end");
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void loadMap(boolean eraseExisting) {
        File f = new File(this.file);
        if (eraseExisting && f.exists()) {
            f.delete();
        }
        if (!f.exists()) {
            Utils.recursiveCreateDir(f.getParent());
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                log.error(e.getMessage() + " " + f.getPath(), (Throwable)e);
            }
            return;
        }
        if (f.length() <= 0L) {
            return;
        }
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(this.file);
            in = new ObjectInputStream(fis);
            Map loadedMap = (Map)in.readObject();
            this.map.clear();
            this.map.putAll(loadedMap);
            in.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

