/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl2java.ast;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.ParamStyle;
import org.jvnet.ws.wadl.Resource;
import org.jvnet.ws.wadl.ResourceType;
import org.jvnet.ws.wadl2java.ElementResolver;
import org.jvnet.ws.wadl2java.ast.AstMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathSegment {
    private String template;
    private List<Param> templateParameters;
    private List<Param> matrixParameters;
    private List<Param> queryParameters;
    private List<Param> headerParameters;

    public PathSegment(String template) {
        this(template, null);
    }

    public PathSegment(String template, List<String> matrixParameters) {
        this.template = template;
        this.templateParameters = new ArrayList<Param>();
        this.matrixParameters = new ArrayList<Param>();
        this.queryParameters = new ArrayList<Param>();
        this.headerParameters = new ArrayList<Param>();
        Pattern embeddedParamPattern = Pattern.compile("\\{.*?\\}");
        Matcher matcher = embeddedParamPattern.matcher(template);
        while (matcher.find()) {
            String paramName = matcher.group();
            paramName = paramName.substring(1, paramName.length() - 1);
            Param embeddedParam = new Param();
            embeddedParam.setName(paramName);
            this.templateParameters.add(embeddedParam);
        }
        if (matrixParameters != null) {
            for (String matrixParam : matrixParameters) {
                Param p = new Param();
                p.setName(matrixParam);
                p.setStyle(ParamStyle.MATRIX);
                this.matrixParameters.add(p);
            }
        }
    }

    public PathSegment(Resource resource, URI file, ElementResolver idMap) {
        this.template = resource.getPath() == null ? "" : resource.getPath();
        this.templateParameters = new ArrayList<Param>();
        this.matrixParameters = new ArrayList<Param>();
        this.queryParameters = new ArrayList<Param>();
        this.headerParameters = new ArrayList<Param>();
        HashMap<String, Param> pathParameters = new HashMap<String, Param>();
        for (Param p : resource.getParam()) {
            if ((p = PathSegment.derefIfRequired(p, file, idMap)) == null) continue;
            if (p.getStyle() == null || p.getStyle() == ParamStyle.TEMPLATE) {
                pathParameters.put(p.getName(), p);
                continue;
            }
            if (p.getStyle() == ParamStyle.MATRIX) {
                this.matrixParameters.add(p);
                continue;
            }
            if (p.getStyle() == ParamStyle.QUERY) {
                this.queryParameters.add(p);
                continue;
            }
            if (p.getStyle() != ParamStyle.HEADER) continue;
            this.headerParameters.add(p);
        }
        Pattern embeddedParamPattern = Pattern.compile("\\{.*?\\}");
        Matcher matcher = embeddedParamPattern.matcher(this.template);
        while (matcher.find()) {
            String paramName = matcher.group();
            if (pathParameters.containsKey(paramName = paramName.substring(1, paramName.length() - 1))) {
                this.templateParameters.add((Param)pathParameters.get(paramName));
                continue;
            }
            Param embeddedParam = new Param();
            embeddedParam.setName(paramName);
            this.templateParameters.add(embeddedParam);
        }
    }

    public PathSegment(ResourceType resource, URI file, ElementResolver idMap) {
        this.template = null;
        this.templateParameters = new ArrayList<Param>();
        this.matrixParameters = new ArrayList<Param>();
        this.queryParameters = new ArrayList<Param>();
        this.headerParameters = new ArrayList<Param>();
        HashMap pathParameters = new HashMap();
        for (Param p : resource.getParam()) {
            if ((p = PathSegment.derefIfRequired(p, file, idMap)) == null) continue;
            if (p.getStyle() == ParamStyle.QUERY) {
                this.queryParameters.add(p);
                continue;
            }
            if (p.getStyle() == ParamStyle.MATRIX) {
                this.matrixParameters.add(p);
                continue;
            }
            if (p.getStyle() != ParamStyle.HEADER) continue;
            this.headerParameters.add(p);
        }
    }

    protected static Param derefIfRequired(Param p, URI file, ElementResolver idMap) {
        String href = p.getHref();
        if (href != null && href.length() > 0) {
            return idMap.resolve(file, href, Param.class);
        }
        return p;
    }

    public String getTemplate() {
        return this.template;
    }

    public List<Param> getTemplateParameters() {
        return this.templateParameters;
    }

    public List<Param> getMatrixParameters() {
        return this.matrixParameters;
    }

    public List<Param> getQueryParameters() {
        return this.queryParameters;
    }

    public List<Param> getHeaderParameters() {
        return this.headerParameters;
    }

    public String evaluate(Map<String, Object> parameterValues) {
        String retVal = this.template;
        if (parameterValues == null) {
            parameterValues = new HashMap<String, Object>();
        }
        for (Param param : this.templateParameters) {
            String paramName = param.getName();
            String paramValue = "";
            if (parameterValues.containsKey(paramName)) {
                paramValue = parameterValues.get(paramName).toString();
            } else if (param.isRequired()) {
                throw new IllegalArgumentException(AstMessages.TEMPLATE_VALUE_MISSING(paramName));
            }
            retVal = retVal.replaceAll("\\{" + paramName + "\\}", paramValue);
        }
        StringBuffer buf = new StringBuffer(retVal);
        for (Param param : this.matrixParameters) {
            String paramName = param.getName();
            Object paramObject = null;
            if (parameterValues.containsKey(paramName)) {
                paramObject = parameterValues.get(paramName);
            } else if (param.isRequired()) {
                throw new IllegalArgumentException(AstMessages.MATRIX_VALUE_MISSING(paramName));
            }
            if (paramObject == null) continue;
            if (paramObject instanceof Boolean) {
                Boolean b = (Boolean)paramObject;
                if (!b.booleanValue()) continue;
                buf.append(';');
                buf.append(paramName);
                continue;
            }
            buf.append(';');
            buf.append(paramName);
            buf.append('=');
            buf.append(String.valueOf(paramObject));
        }
        return buf.toString();
    }
}

