/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.versioncontrol.jgit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.tools.ant.filters.StringInputStream;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;
import org.hyperic.cm.versioncontrol.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedFileTreeIterator
extends WorkingTreeIterator {
    private static Logger logger = LoggerFactory.getLogger(ExtendedFileTreeIterator.class);
    protected File directory;
    protected FS fs;
    protected Set<String> extensionsForMd5 = null;

    public ExtendedFileTreeIterator(Repository repo, String root) {
        super("", (WorkingTreeOptions)repo.getConfig().get(WorkingTreeOptions.KEY));
        this.directory = new File(root + File.separator);
        this.fs = repo.getFS();
        ExtendedFileEntry e = new ExtendedFileEntry(new File(root), this.fs, false);
        this.init(new WorkingTreeIterator.Entry[]{e});
        this.initRootIterator(repo);
    }

    protected ExtendedFileTreeIterator(ExtendedFileTreeIterator p, File root, FS fs) {
        super((WorkingTreeIterator)p);
        this.directory = root;
        this.fs = fs;
        this.init(this.entries());
    }

    protected ExtendedFileTreeIterator(WorkingTreeIterator p) {
        super(p);
    }

    protected ExtendedFileTreeIterator(String prefix, WorkingTreeOptions options) {
        super(prefix, options);
    }

    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        WorkingTreeIterator.Entry e = this.current();
        return new ExtendedFileTreeIterator(this, ((ExtendedFileEntry)e).getFile(), this.fs);
    }

    private WorkingTreeIterator.Entry[] entries() {
        String s = this.directory.getPath();
        File[] all = s.length() == 2 && s.charAt(1) == ':' ? new File(s + File.separator).listFiles() : this.directory.listFiles();
        if (all == null) {
            return EOF;
        }
        WorkingTreeIterator.Entry[] r = new WorkingTreeIterator.Entry[all.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new ExtendedFileEntry(all[i], this.fs, this.isBinary(all[i].getName()));
        }
        return r;
    }

    public Set<String> getExtensionsForMd5() {
        return this.extensionsForMd5;
    }

    public void setExtensionsForMd5(Set<String> extensions) {
        this.extensionsForMd5 = extensions;
    }

    protected boolean isBinary(String path) {
        if (this.extensionsForMd5 == null || this.extensionsForMd5.size() <= 0 || path == null || path.length() <= 0) {
            return false;
        }
        return this.extensionsForMd5.contains(Utils.getFileExtension(Utils.fileName(path)));
    }

    public File getDirectory() {
        return this.directory;
    }

    public File getEntryFile() {
        return ((FileTreeIterator.FileEntry)this.current()).getFile();
    }

    public static class ExtendedFileEntry
    extends WorkingTreeIterator.Entry {
        protected File file;
        protected FileMode mode;
        protected long length = -1L;
        protected long lastModified;
        protected String md5String;
        protected boolean isBinary;
        protected String name;

        public ExtendedFileEntry(File f, FS fs, boolean isBinary) {
            this.file = f;
            this.isBinary = isBinary;
            this.mode = f.isDirectory() ? FileMode.TREE : (fs.canExecute(this.file) ? FileMode.EXECUTABLE_FILE : FileMode.REGULAR_FILE);
            this.length = this.file.length();
            String string = this.name = this.file.getName().length() == 0 ? Utils.getRoot(this.file.getPath()) : this.file.getName();
            if (isBinary) {
                this.getMd5();
                if (this.md5String != null && this.md5String.length() > 0) {
                    this.length = this.md5String.length();
                }
            }
        }

        public ExtendedFileEntry() {
        }

        public FileMode getMode() {
            return this.mode;
        }

        public String getName() {
            return this.name;
        }

        public long getLength() {
            return this.length;
        }

        protected void getMd5() {
            try {
                InputStream is = this.openInputStream();
                this.md5String = Utils.getMd5Stream(is);
                is.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.md5String = "";
            }
        }

        public long getLastModified() {
            if (this.lastModified == 0L) {
                this.lastModified = this.file.lastModified();
            }
            return this.lastModified;
        }

        public InputStream openInputStream() throws IOException {
            if (this.md5String != null && this.md5String.length() > 0) {
                return new StringInputStream(this.md5String);
            }
            return new FileInputStream(this.file);
        }

        public File getFile() {
            return this.file;
        }
    }
}

