/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.lather;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hyperic.lather.LatherValue;
import org.hyperic.util.TextIndenter;

public class LatherDump {
    private PrintWriter pWriter;

    public LatherDump(OutputStream oStream) {
        this.pWriter = new PrintWriter(oStream);
    }

    private String getClassOnly(Class fClass) {
        String cName = fClass.getName();
        return cName.substring(cName.lastIndexOf(".") + 1);
    }

    private String getVal(Object o) {
        if (o instanceof byte[]) {
            return "[" + ((byte[])o).length + "]";
        }
        return o.toString();
    }

    private void dumpEnt(TextIndenter tInd, Map map, String type) {
        for (Map.Entry ent : map.entrySet()) {
            String val = this.getVal(ent.getValue());
            tInd.append(ent.getKey() + " = " + type + "(" + val + ")\n");
        }
    }

    private void dumpList(TextIndenter tInd, Map map, String type) {
        for (Map.Entry ent : map.entrySet()) {
            List l = (List)ent.getValue();
            tInd.append(ent.getKey() + " = [" + type + "]\n");
            tInd.pushIndent();
            Iterator j = l.iterator();
            while (j.hasNext()) {
                tInd.append(this.getVal(j.next()));
            }
            tInd.popIndent();
        }
    }

    private void dump(LatherValue val, TextIndenter tInd) {
        tInd.append("[Dump of " + this.getClassOnly(val.getClass()) + "]\n");
        tInd.pushIndent();
        this.dumpEnt(tInd, val.getStringVals(), "String");
        this.dumpEnt(tInd, val.getIntVals(), "Int");
        this.dumpEnt(tInd, val.getDoubleVals(), "Double");
        this.dumpEnt(tInd, val.getByteAVals(), "ByteA");
        for (Map.Entry ent : val.getObjectVals().entrySet()) {
            tInd.append(ent.getKey() + " = Object()\n");
            this.dump((LatherValue)ent.getValue(), tInd);
        }
        this.dumpList(tInd, val.getStringLists(), "String");
        this.dumpList(tInd, val.getIntLists(), "Int");
        this.dumpList(tInd, val.getDoubleLists(), "Double");
        this.dumpList(tInd, val.getByteALists(), "ByteA");
        for (Map.Entry ent : val.getObjectLists().entrySet()) {
            List l = (List)ent.getValue();
            tInd.append(ent.getKey() + " = [Object]\n");
            Iterator j = l.iterator();
            while (j.hasNext()) {
                this.dump((LatherValue)j.next(), tInd);
            }
        }
        tInd.popIndent();
    }

    public void dump(LatherValue val) {
        TextIndenter tInd = new TextIndenter();
        this.dump(val, tInd);
        this.pWriter.print(tInd.toString());
        this.pWriter.flush();
    }
}

