/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.lather.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.common.SystemException;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;
import org.hyperic.lather.client.LatherClient;
import org.hyperic.lather.xcode.LatherXCoder;
import org.hyperic.util.encoding.Base64;
import org.hyperic.util.http.HQHttpClient;
import org.hyperic.util.http.HttpConfig;
import org.hyperic.util.security.KeystoreConfig;

public class LatherHTTPClient
implements LatherClient {
    private static final int TIMEOUT_CONN = 10000;
    private static final int TIMEOUT_DATA = 10000;
    public static final String HDR_ERROR = "X-error-response";
    public static final String HDR_VALUECLASS = "X-latherValue-class";
    private HQHttpClient client;
    private LatherXCoder xCoder;
    private String baseURL;

    public LatherHTTPClient(String baseURL) throws Exception {
        this(baseURL, 10000, 10000);
    }

    public LatherHTTPClient(String baseURL, int timeoutConn, int timeoutData) {
        this(baseURL, timeoutConn, timeoutData, new AgentKeystoreConfig().isAcceptUnverifiedCert());
    }

    public LatherHTTPClient(String baseURL, int timeoutConn, int timeoutData, boolean acceptUnverifiedCertificates) {
        try {
            String proxyHostname = System.getProperty("lather.proxyHost", null);
            int proxyPort = Integer.getInteger("lather.proxyPort", new Integer(-1));
            HttpConfig config = new HttpConfig();
            config.setConnectionTimeout(timeoutConn);
            config.setSocketTimeout(timeoutData);
            config.setProxyHostname(proxyHostname);
            config.setProxyPort(proxyPort);
            this.client = new HQHttpClient((KeystoreConfig)new AgentKeystoreConfig(), config, acceptUnverifiedCertificates);
            this.baseURL = baseURL;
            this.xCoder = new LatherXCoder();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public LatherValue invoke(String method, LatherValue args) throws IOException, LatherRemoteException {
        ByteArrayOutputStream bOs = new ByteArrayOutputStream();
        DataOutputStream dOs = new DataOutputStream(bOs);
        this.xCoder.encode(args, dOs);
        byte[] rawData = bOs.toByteArray();
        String encodedArgs = Base64.encode((byte[])rawData);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("method", method);
        postParams.put("args", encodedArgs);
        postParams.put("argsClass", args.getClass().getName());
        HttpResponse response = this.client.post(this.baseURL, postParams);
        if (response != null && response.getStatusLine().getStatusCode() == 200) {
            ByteArrayInputStream bIs;
            Class<?> resClass;
            Header errHeader = response.getFirstHeader(HDR_ERROR);
            Header clsHeader = response.getFirstHeader(HDR_VALUECLASS);
            HttpEntity entity = response.getEntity();
            String responseBody = EntityUtils.toString((HttpEntity)entity);
            if (errHeader != null) {
                throw new LatherRemoteException(responseBody);
            }
            if (clsHeader == null) {
                throw new IOException("Server returned malformed result: did not contain a value class header");
            }
            try {
                resClass = Class.forName(clsHeader.getValue());
            }
            catch (ClassNotFoundException exc) {
                throw new LatherRemoteException("Server returned a class '" + clsHeader.getValue() + "' which the client did not have access to");
            }
            try {
                bIs = new ByteArrayInputStream(Base64.decode((String)responseBody));
            }
            catch (IllegalArgumentException e) {
                throw new SystemException("could not decode response from server body=" + responseBody, (Throwable)e);
            }
            DataInputStream dIs = new DataInputStream(bIs);
            return this.xCoder.decode(dIs, resClass);
        }
        throw new IOException("Connection failure: " + response.getStatusLine());
    }
}

