/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBranchCommand
extends GitCommand<List<Ref>> {
    private ListMode listMode;

    protected ListBranchCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<Ref> call() throws JGitInternalException {
        Map<String, Ref> refList;
        this.checkCallable();
        try {
            if (this.listMode == null) {
                refList = this.repo.getRefDatabase().getRefs("refs/heads/");
            } else if (this.listMode == ListMode.REMOTE) {
                refList = this.repo.getRefDatabase().getRefs("refs/remotes/");
            } else {
                refList = new HashMap<String, Ref>(this.repo.getRefDatabase().getRefs("refs/heads/"));
                refList.putAll(this.repo.getRefDatabase().getRefs("refs/remotes/"));
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        ArrayList<Ref> resultRefs = new ArrayList<Ref>();
        resultRefs.addAll(refList.values());
        Collections.sort(resultRefs, new Comparator<Ref>(){

            @Override
            public int compare(Ref o1, Ref o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.setCallable(false);
        return resultRefs;
    }

    public ListBranchCommand setListMode(ListMode listMode) {
        this.checkCallable();
        this.listMode = listMode;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ListMode {
        ALL,
        REMOTE;

    }
}

