/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.exchange;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.PumpStreamHandler;

public class ExchangeUtils {
    protected static final String EXCHANGE_ROLE_REG_KEY = "EXCHANGE_ROLE_REG_KEY";
    protected static final String DAG_DISCOVERY = "DAG_DISCOVERY";
    protected static final String DAG_NAME = "DAG_name";
    protected static final String SITE_DISCOVERY = "SITE_DISCOVERY";
    protected static final String AD_SITE_PROP = "active_directory.site";
    private static final Log log = LogFactory.getLog((String)ExchangeUtils.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean checkRoleConfiguredAndSetVersion(String roleRegKeyStr, ConfigResponse cprops) {
        RegistryKey key = null;
        try {
            key = RegistryKey.LocalMachine.openSubKey(roleRegKeyStr);
            String version = key.getStringValue("ConfiguredVersion").trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("version=[" + version + "]"));
            }
            if (version != null) {
                cprops.setValue("version", version);
            }
            boolean bl = true;
            return bl;
        }
        catch (Win32Exception e) {
            log.warn((Object)("ExchangeUtils: didn't find ConfiguredVersion in:" + roleRegKeyStr));
            boolean bl = false;
            return bl;
        }
        finally {
            if (key != null) {
                key.close();
            }
        }
    }

    protected static String fetchActiveDirectorySiteName() {
        String resultSiteName = "";
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Execute exec = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)output));
            exec.setCommandline(new String[]{"nltest", "/DsGetSite"});
            int rc = exec.execute();
            String out = output.toString().trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("output of " + exec.getCommandLineString() + " : " + out));
            }
            if (rc == 0) {
                BufferedReader in = null;
                in = new BufferedReader(new StringReader(output.toString()));
                resultSiteName = in.readLine();
            }
        }
        catch (Exception e) {
            log.warn((Object)("Failed to fetch active directory site name: " + e.getMessage()), (Throwable)e);
        }
        return resultSiteName;
    }
}

