/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.diagnostics;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.diagnostics.AgentDiagnosticObject;
import org.hyperic.hq.stats.AbstractStatsWriter;
import org.hyperic.util.TimeUtil;

public class AgentDiagnostics
extends Thread {
    private static final String BASE_NAME = "agent-diags-<day>";
    private static final long MINUTE = 60000L;
    private final Log log = LogFactory.getLog(AgentDiagnostics.class);
    private final Collection<AgentDiagnosticObject> diags = new ArrayList<AgentDiagnosticObject>();
    private String currFilename = null;
    private FileWriter currFile = null;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private String basedir;
    private static final AgentDiagnostics instance = new AgentDiagnostics();

    private AgentDiagnostics() {
        super("AgentDiagnostics");
        this.setDaemon(true);
    }

    public void die() {
        this.shutdown.set(true);
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiagnostic(AgentDiagnosticObject o) {
        Collection<AgentDiagnosticObject> collection = this.diags;
        synchronized (collection) {
            this.diags.add(o);
        }
    }

    public void setConfig(AgentConfig config) {
        this.basedir = config.getLogDir().getAbsolutePath();
    }

    public void run() {
        this.log.info((Object)"starting agent diagnostics thread");
        while (!this.shutdown.get()) {
            try {
                Thread.sleep(600000L);
                if (this.basedir == null) continue;
                this.writeDiags();
            }
            catch (Throwable t) {
                if (!this.shutdown.get()) {
                    this.log.error((Object)t, t);
                    continue;
                }
                this.log.info((Object)"Agent Diagnostic Thread exiting");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDiags() throws IOException {
        Collection<AgentDiagnosticObject> diagObjs;
        StringBuilder status = new StringBuilder(1024);
        status.append("\n\n#=======================\n#").append(TimeUtil.toString((long)System.currentTimeMillis())).append("\n#=======================");
        Collection<AgentDiagnosticObject> collection = this.diags;
        synchronized (collection) {
            diagObjs = Collections.unmodifiableCollection(this.diags);
        }
        for (AgentDiagnosticObject o : diagObjs) {
            status.append("\n\n#").append(o.getDiagName()).append("\n");
            status.append(o.getDiagStatus());
        }
        String filename = this.getFilename();
        if (this.currFilename == null) {
            this.currFile = new FileWriter(filename, true);
            this.currFilename = filename;
        } else if (!filename.equals(this.currFilename)) {
            if (this.currFile != null) {
                this.currFile.close();
            }
            AbstractStatsWriter.gzipFile((String)this.currFilename);
            this.currFile = new FileWriter(filename, true);
            this.currFilename = filename;
        }
        this.currFile.append(status);
        this.currFile.flush();
    }

    private final String getFilename() {
        SimpleDateFormat f = new SimpleDateFormat("EEEE");
        String day = f.format(new Date(System.currentTimeMillis()));
        String fs = File.separator;
        return this.basedir + fs + BASE_NAME.replace("<day>", day) + ".txt";
    }

    public static AgentDiagnostics getInstance() {
        return instance;
    }
}

