/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.server.AgentTransportLifecycle;
import org.hyperic.hq.bizapp.agent.CommandsAPIInfo;
import org.hyperic.hq.bizapp.agent.ProviderInfo;
import org.hyperic.hq.bizapp.client.AgentCallbackClient;
import org.hyperic.hq.common.YesOrNo;
import org.hyperic.hq.transport.AgentTransport;
import org.jboss.remoting.InvokerLocator;

public final class AgentTransportLifecycleImpl
implements AgentTransportLifecycle {
    private static final Log _log = LogFactory.getLog(AgentTransportLifecycleImpl.class);
    private static final String REMOTE_TRANSPORT_LOCATOR_PATH = "ServerInvokerServlet";
    private final Object _lock = new Object();
    private final AgentDaemon _agent;
    private final AgentConfig _config;
    private final AgentStorageProvider _storageProvider;
    private final Map _serviceInterfaceName2ServiceInterface;
    private final Map _serviceInterface2ServiceImpl;
    private AgentTransport _agentTransport;
    private InvokerLocator _remoteTransportLocator;

    public AgentTransportLifecycleImpl(AgentDaemon agent, AgentConfig bootConfig, AgentStorageProvider storageProvider) {
        this._agent = agent;
        this._config = bootConfig;
        this._storageProvider = storageProvider;
        this._serviceInterfaceName2ServiceInterface = new HashMap();
        this._serviceInterface2ServiceImpl = new HashMap();
        this._agent.registerNotifyHandler(this, CommandsAPIInfo.NOTIFY_SERVER_SET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAgentTransport() throws Exception {
        Object pollerBindAddr;
        String host;
        ProviderInfo provider = CommandsAPIInfo.getProvider(this._storageProvider);
        Properties bootProperties = this._config.getBootProperties();
        boolean isNewTransport = this.isNewTransport(bootProperties, provider);
        if (!isNewTransport) {
            _log.info((Object)"Agent is not using new transport.");
            return;
        }
        _log.info((Object)"Agent is using the new transport. Looking for properties to start the new transport.");
        boolean isUnidirectionalPropertySet = this.isUnidirectionalPropertySet(bootProperties, provider);
        _log.info((Object)("Unidirectional property set=" + isUnidirectionalPropertySet));
        boolean unidirectional = false;
        if (isUnidirectionalPropertySet) {
            unidirectional = this.isUnidirectional(bootProperties, provider);
            _log.info((Object)("Unidirectional=" + unidirectional));
        }
        if ((host = this.getHost(bootProperties, provider)) == null) {
            _log.info((Object)"Host is not currently set.");
        } else {
            _log.info((Object)("Host=" + host));
        }
        int unidirectionalPort = this.getUndirectionalPort(bootProperties, provider);
        if (unidirectionalPort == -1) {
            _log.info((Object)"Unidirectional port is not currently set.");
        } else {
            _log.info((Object)("Unidirectional port=" + unidirectionalPort));
        }
        String agentToken = this.getAgentToken(provider);
        if (agentToken == null) {
            _log.info((Object)"Agent token is not currently set. Registering handler to notify agent transport when token is set.");
        } else {
            _log.info((Object)("Agent token=" + agentToken));
        }
        long pollingFrequency = this.getPollingFrequency(bootProperties);
        _log.info((Object)("Polling frequency=" + pollingFrequency));
        if (!isUnidirectionalPropertySet) {
            _log.info((Object)"Cannot start new transport since we do not know if the transport is unidirectional.");
            return;
        }
        if (host == null) {
            _log.info((Object)"Cannot start new transport since we do not know the host.");
            return;
        }
        if (unidirectional) {
            if (unidirectionalPort == -1) {
                _log.info((Object)"Cannot start new transport since we do not know the server port for the unidirectional transport.");
                return;
            }
            _log.info((Object)"Setting up unidirectional transport");
            pollerBindAddr = new InetSocketAddress(host, unidirectionalPort);
            if (this._config.isProxyServerSet()) {
                _log.info((Object)("Configuring proxy host and port: host=" + this._config.getProxyIp() + "; port=" + this._config.getProxyPort()));
                System.setProperty("https.proxyHost", this._config.getProxyIp());
                System.setProperty("https.proxyPort", String.valueOf(this._config.getProxyPort()));
            }
            this._agentTransport = new AgentTransport((InetSocketAddress)pollerBindAddr, REMOTE_TRANSPORT_LOCATOR_PATH, true, agentToken, unidirectional, pollingFrequency, 1);
        } else {
            _log.info((Object)"Setting up bidirectional transport");
            this._agentTransport = null;
        }
        if (this._agentTransport != null) {
            pollerBindAddr = this._lock;
            synchronized (pollerBindAddr) {
                this._remoteTransportLocator = this._agentTransport.getRemoteEndpointLocator();
            }
            for (Map.Entry entry : this._serviceInterface2ServiceImpl.entrySet()) {
                Class serviceInterface = (Class)entry.getKey();
                Object serviceImpl = entry.getValue();
                this._agentTransport.registerService(serviceInterface, serviceImpl);
            }
            this._agentTransport.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAgentTransport() {
        if (this._agentTransport != null) {
            try {
                this._agentTransport.stop();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._agentTransport = null;
            Object object = this._lock;
            synchronized (object) {
                this._remoteTransportLocator = null;
            }
        }
    }

    public void handleNotification(String msgClass, String msg) {
        ProviderInfo provider = CommandsAPIInfo.getProvider(this._storageProvider);
        Properties bootProperties = this._config.getBootProperties();
        if (!this.isNewTransport(bootProperties, provider)) {
            _log.info((Object)"Stopping agent transport.");
            this.stopAgentTransport();
            return;
        }
        if (this._agentTransport == null) {
            try {
                this.startAgentTransport();
            }
            catch (Exception e) {
                _log.error((Object)"Failed to start agent transport after agent setup", (Throwable)e);
                return;
            }
        }
        if (this._agentTransport == null && this.isUnidirectional(bootProperties, provider)) {
            _log.error((Object)"Failed to start agent transport after agent setup");
            return;
        }
        if (provider == null) {
            _log.error((Object)"Agent transport expected agent token set but storage provider does not have token.");
        } else if (this._agentTransport != null) {
            String agentToken = provider.getAgentToken();
            _log.info((Object)("Updating agent transport with new agent token: " + agentToken));
            this._agentTransport.updateAgentToken(agentToken);
        }
    }

    public void registerService(Class serviceInterface, Object serviceImpl) {
        Class oldInterface = (Class)this._serviceInterfaceName2ServiceInterface.get(serviceInterface.getName());
        if (oldInterface == null) {
            this._serviceInterfaceName2ServiceInterface.put(serviceInterface.getName(), serviceInterface);
            this._serviceInterface2ServiceImpl.put(serviceInterface, serviceImpl);
        } else {
            this._serviceInterfaceName2ServiceInterface.remove(serviceInterface.getName());
            this._serviceInterface2ServiceImpl.remove(oldInterface);
            this._serviceInterfaceName2ServiceInterface.put(serviceInterface.getName(), serviceInterface);
            this._serviceInterface2ServiceImpl.put(serviceInterface, serviceImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvokerLocator getRemoteTransportLocator() {
        Object object = this._lock;
        synchronized (object) {
            return this._remoteTransportLocator;
        }
    }

    private boolean isNewTransport(Properties bootProperties, ProviderInfo provider) {
        boolean isNewTransport = false;
        String isNewTransportString = bootProperties.getProperty("agent.setup.newTransport");
        if (isNewTransportString == null) {
            if (provider != null) {
                isNewTransport = provider.isNewTransport();
            }
        } else {
            isNewTransport = YesOrNo.valueFor((String)isNewTransportString).toBoolean();
        }
        return isNewTransport;
    }

    private boolean isUnidirectionalPropertySet(Properties bootProperties, ProviderInfo provider) {
        String isUnidirectionalString = bootProperties.getProperty("agent.setup.unidirectional");
        if (isUnidirectionalString != null) {
            return true;
        }
        if (provider != null) {
            return provider.isNewTransport();
        }
        return false;
    }

    private boolean isUnidirectional(Properties bootProperties, ProviderInfo provider) {
        boolean isUnidirectional = false;
        String isUnidirectionalString = bootProperties.getProperty("agent.setup.unidirectional");
        if (isUnidirectionalString == null && provider != null) {
            if (provider.isNewTransport()) {
                isUnidirectional = provider.isUnidirectional();
            }
        } else {
            isUnidirectional = YesOrNo.valueFor((String)isUnidirectionalString).toBoolean();
        }
        return isUnidirectional;
    }

    private String getHost(Properties bootProperties, ProviderInfo provider) {
        String host = bootProperties.getProperty("agent.setup.camIP");
        if (host == null && provider != null) {
            host = AgentCallbackClient.getHostFromProviderURL(provider.getProviderAddress());
        }
        return host;
    }

    private int getUndirectionalPort(Properties bootProperties, ProviderInfo provider) {
        int port = -1;
        String portString = bootProperties.getProperty("agent.setup.camSSLPort");
        if (portString == null) {
            if (provider != null && provider.isNewTransport()) {
                port = provider.getUnidirectionalPort();
            }
        } else {
            port = Integer.valueOf(portString);
        }
        return port;
    }

    private long getPollingFrequency(Properties bootProperties) {
        String pollingFrequencyString = bootProperties.getProperty("agent.setup.uniPollingFrequency");
        if (pollingFrequencyString == null) {
            return 1000L;
        }
        return Long.valueOf(pollingFrequencyString);
    }

    private String getAgentToken(ProviderInfo provider) {
        if (provider != null) {
            return provider.getAgentToken();
        }
        return null;
    }
}

