/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentCommand;
import org.hyperic.hq.agent.AgentConnectionException;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentConnectionListener;
import org.hyperic.hq.agent.server.AgentRunningException;
import org.hyperic.hq.agent.server.AgentServerConnection;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.CommandDispatcher;
import org.hyperic.hq.agent.server.monitor.AgentMonitorSimple;

public class CommandListener
extends AgentMonitorSimple {
    private static final int POLL_FREQUENCY = 1000;
    private static final String GENERIC_POOL = "generic";
    private static final String[] THREAD_POOLS = new String[]{"agent:ping", "agent:receive_file", "generic"};
    private final Map<String, ExecutorService> threadPools = new HashMap<String, ExecutorService>();
    private final CommandDispatcher dispatcher;
    private final Log log = LogFactory.getLog(CommandListener.class);
    private AtomicBoolean shutdown = new AtomicBoolean(true);
    private AtomicReference<AgentConnectionListener> listener = new AtomicReference();

    CommandListener(CommandDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.setupThreadPools();
    }

    private void setupThreadPools() {
        for (String cmdName : THREAD_POOLS) {
            final String poolName = cmdName.replace("agent:", "");
            ExecutorService pool = Executors.newFixedThreadPool(1, new ThreadFactory(){
                private final AtomicLong num = new AtomicLong(0L);

                public Thread newThread(Runnable r) {
                    Thread rtn = new Thread(r, "commandlistener-" + poolName + "-" + this.num.getAndIncrement());
                    rtn.setDaemon(true);
                    return rtn;
                }
            });
            this.threadPools.put(cmdName, pool);
        }
    }

    void setConnectionListener(final AgentConnectionListener listener) throws AgentRunningException {
        if (!this.shutdown.get()) {
            throw new AgentRunningException("Cannot replace listener while running");
        }
        this.listener.set(listener);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    if (listener != null) {
                        listener.cleanup();
                    }
                }
                catch (Throwable e) {
                    CommandListener.this.log.error((Object)("could not close socket connection: " + e), e);
                }
            }
        });
    }

    void die() throws AgentRunningException {
        this.shutdown.set(true);
        for (Map.Entry<String, ExecutorService> entry : this.threadPools.entrySet()) {
            ExecutorService pool = entry.getValue();
            pool.shutdownNow();
            this.log.info((Object)("Shut down executor service for CommandListener " + entry.getKey()));
        }
    }

    void cleanup() {
        this.listener.get().cleanup();
    }

    void setup() throws AgentStartException {
        this.listener.get().setup(1000);
    }

    void listenLoop() {
        boolean logDebug = this.log.isDebugEnabled();
        this.shutdown.set(false);
        while (!this.shutdown.get()) {
            try {
                try {
                    AgentServerConnection conn = this.listener.get().getNewConnection();
                    if (logDebug) {
                        this.log.debug((Object)"Opened new connection");
                    }
                    AgentCommand cmd = conn.readCommand();
                    ExecutorService pool = this.getPool(cmd);
                    if (logDebug) {
                        this.log.debug((Object)("Dispatching command " + cmd.getCommand() + " to pool: " + pool));
                    }
                    pool.execute(new AgentDispatchTask(conn, cmd));
                    if (!logDebug) continue;
                    this.log.debug((Object)("Done dispatching command " + cmd.getCommand() + " to pool " + pool));
                }
                catch (EOFException e) {
                    this.log.debug((Object)e, (Throwable)e);
                }
                catch (InterruptedIOException e) {
                    if (!this.shutdown.get()) continue;
                    this.listener.get().cleanup();
                    return;
                }
                catch (AgentConnectionException e) {
                    if (this.shutdown.get()) continue;
                    this.log.error((Object)("Failed handling new connection: " + (Object)((Object)e)), (Throwable)e);
                }
            }
            catch (Throwable t) {
                if (!this.shutdown.get()) {
                    this.log.error((Object)t, t);
                    continue;
                }
                this.log.debug((Object)t, t);
            }
        }
    }

    private ExecutorService getPool(AgentCommand cmd) {
        ExecutorService pool = this.threadPools.get(cmd.getCommand());
        return pool == null ? this.threadPools.get(GENERIC_POOL) : pool;
    }

    private void handleConn(AgentServerConnection conn, AgentCommand cmd, InputStream inputStream, OutputStream outputStream) {
        AgentRemoteException dispatchResult;
        try {
            this.log.debug((Object)("Dispatching request for '" + cmd.getCommand() + "'"));
            dispatchResult = this.dispatcher.processRequest(cmd, inputStream, outputStream);
        }
        catch (AgentRemoteException e) {
            dispatchResult = e;
        }
        try {
            if (dispatchResult instanceof AgentRemoteException) {
                this.log.warn((Object)"Error invoking method", (Throwable)((Exception)((Object)dispatchResult)));
                String message = dispatchResult.getMessage();
                if (message == null) {
                    message = "Problem occurred without an error message, see stacktrace for more information.";
                }
                conn.sendErrorResponse(message);
            } else if (dispatchResult instanceof Exception) {
                this.log.warn((Object)"Error invoking method", (Throwable)((Exception)((Object)dispatchResult)));
                conn.sendErrorResponse(((Exception)((Object)dispatchResult)).toString());
            } else if (dispatchResult == null) {
                this.log.debug((Object)("Method '" + cmd + "' returned null "));
                conn.sendSuccessResponse(new AgentRemoteValue());
            } else {
                this.log.debug((Object)("Method '" + cmd + "' returned an object result"));
                conn.sendSuccessResponse((AgentRemoteValue)dispatchResult);
            }
        }
        catch (AgentConnectionException e) {
            this.log.error((Object)("Error writing result to client: " + (Object)((Object)e)), (Throwable)e);
        }
    }

    private class AgentDispatchTask
    implements Runnable {
        private AgentServerConnection conn;
        private AgentCommand cmd;

        public AgentDispatchTask(AgentServerConnection conn, AgentCommand cmd) {
            this.conn = conn;
            this.cmd = cmd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block19: {
                InputStream inputStream = null;
                OutputStream outputStream = null;
                inputStream = this.conn.getInputStream();
                outputStream = this.conn.getOutputStream();
                CommandListener.this.handleConn(this.conn, this.cmd, inputStream, outputStream);
                Object var5_3 = null;
                try {
                    outputStream.flush();
                }
                catch (IOException ignExc) {
                    // empty catch block
                }
                try {
                    outputStream.close();
                }
                catch (IOException ignExc) {
                    // empty catch block
                }
                try {
                    inputStream.close();
                }
                catch (IOException ignExc) {
                    // empty catch block
                }
                this.conn.close();
                {
                    break block19;
                    catch (Throwable t) {
                        CommandListener.this.log.error((Object)t, t);
                        Object var5_4 = null;
                        try {
                            outputStream.flush();
                        }
                        catch (IOException ignExc) {
                            // empty catch block
                        }
                        try {
                            outputStream.close();
                        }
                        catch (IOException ignExc) {
                            // empty catch block
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException ignExc) {
                            // empty catch block
                        }
                        this.conn.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        outputStream.flush();
                    }
                    catch (IOException ignExc) {
                        // empty catch block
                    }
                    try {
                        outputStream.close();
                    }
                    catch (IOException ignExc) {
                        // empty catch block
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException ignExc) {
                        // empty catch block
                    }
                    this.conn.close();
                    throw throwable;
                }
            }
        }
    }
}

