/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentConnectionException;
import org.hyperic.hq.agent.server.AgentConnectionListener;
import org.hyperic.hq.agent.server.AgentServerConnection;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.DefaultServerConnection;

class DefaultConnectionListener
extends AgentConnectionListener {
    private Log log = LogFactory.getLog(DefaultConnectionListener.class);
    private ServerSocket listenSock = null;

    DefaultConnectionListener(AgentConfig cfg) {
        super(cfg);
    }

    public void setup(int connTimeout) throws AgentStartException {
        InetAddress addr;
        int listenPort = this.getConfig().getListenPort();
        try {
            addr = this.getConfig().getListenIpAsAddr();
        }
        catch (UnknownHostException exc) {
            throw new AgentStartException("Failed to get IP for '" + this.getConfig().getListenIp() + "'");
        }
        try {
            this.listenSock = new ServerSocket(listenPort, 50, addr);
            this.listenSock.setSoTimeout(connTimeout);
        }
        catch (IOException exc) {
            throw new AgentStartException("Failed to setup listen socket: " + exc.getMessage());
        }
    }

    public void cleanup() {
        if (this.listenSock != null) {
            this.log.info((Object)("closing listener socket " + this.listenSock.getInetAddress() + ":" + this.listenSock.getLocalPort()));
            try {
                this.listenSock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.listenSock = null;
        }
    }

    public AgentServerConnection getNewConnection() throws AgentConnectionException, InterruptedIOException {
        Socket conn;
        try {
            conn = this.listenSock.accept();
        }
        catch (InterruptedIOException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new AgentConnectionException("Error accepting socket: " + exc.getMessage(), (Exception)exc);
        }
        return new DefaultServerConnection(conn);
    }
}

