/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.hyperic.hq.bizapp.agent.TokenData;
import org.hyperic.hq.bizapp.agent.TokenManager;
import org.hyperic.hq.bizapp.agent.TokenStorer;

public class AgentClientUtil {
    public static String getLocalAuthToken(String tokenFile) throws FileNotFoundException, IOException {
        int nTries = 20;
        TokenManager tm = new TokenManager(1000000L, null);
        tm.load(new FileInputStream(tokenFile));
        List tokens = tm.getTokens();
        if (tokens.size() == 0) {
            throw new IOException("Token file contains no valid tokens");
        }
        return ((TokenData)tokens.get(0)).getToken();
    }

    public static void generateNewTokenFile(String tokenFile, String firstToken) throws IOException {
        TokenManager tm = new TokenManager(1000000L, new MyStorer(tokenFile));
        tm.addToken(new TokenData(firstToken, System.currentTimeMillis(), true));
        tm.store();
    }

    private static class MyStorer
    implements TokenStorer {
        private String tokenFile;

        private MyStorer() {
        }

        public MyStorer(String tokenFile) {
            this.tokenFile = tokenFile;
        }

        public OutputStream getTokenStoreStream() throws IOException {
            return new FileOutputStream(this.tokenFile);
        }
    }
}

