/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.hyperic.hq.appdef.shared.AppdefEntityID;
import org.hyperic.util.encoding.Base64;

public class ScheduledMeasurement {
    private String dsn;
    private long interval;
    private Integer derivedID;
    private int dsnID;
    private AppdefEntityID ent;
    private String category;
    private long lastCollected;

    public ScheduledMeasurement(String dsn, long interval, int derivedID, int dsnID, AppdefEntityID ent, String category) {
        this.dsn = dsn;
        this.interval = interval;
        this.derivedID = derivedID;
        this.dsnID = dsnID;
        this.ent = ent;
        this.category = category;
    }

    public String toString() {
        int derviedId = this.getDerivedID();
        int dsnId = this.getDsnID();
        String dsn = this.getDSN();
        StringBuffer buf = new StringBuffer(64);
        buf.append("[derivedId=").append(this.getDerivedID()).append("|dsnId=").append(this.getDsnID()).append("]").append("|interval=").append(this.getInterval()).append("]");
        return buf.toString();
    }

    public String getDSN() {
        return this.dsn;
    }

    public long getInterval() {
        return this.interval;
    }

    public int getDerivedID() {
        return this.derivedID;
    }

    public int getDsnID() {
        return this.dsnID;
    }

    public AppdefEntityID getEntity() {
        return this.ent;
    }

    public String getCategory() {
        return this.category;
    }

    public String encode() {
        ByteArrayOutputStream bOs = new ByteArrayOutputStream();
        DataOutputStream dOs = new DataOutputStream(bOs);
        try {
            dOs.writeUTF(this.dsn);
            dOs.writeLong(this.interval);
            dOs.writeInt(this.derivedID);
            dOs.writeInt(this.dsnID);
            dOs.writeInt(this.ent.getType());
            dOs.writeInt(this.ent.getID());
            dOs.writeUTF(this.category);
        }
        catch (IOException exc) {
            System.out.println("Unable to encode record: " + exc.getMessage());
        }
        return Base64.encode((byte[])bOs.toByteArray());
    }

    public static ScheduledMeasurement decode(String data) {
        ByteArrayInputStream bIs = new ByteArrayInputStream(Base64.decode((String)data));
        DataInputStream dIs = new DataInputStream(bIs);
        try {
            String dsn = dIs.readUTF();
            long interval = dIs.readLong();
            int derivedID = dIs.readInt();
            int dsnID = dIs.readInt();
            int entType = dIs.readInt();
            int entID = dIs.readInt();
            String category = dIs.readUTF();
            return new ScheduledMeasurement(dsn, interval, derivedID, dsnID, new AppdefEntityID(entType, entID), category);
        }
        catch (IOException exc) {
            System.out.println("Unable to encode record: " + exc.getMessage());
            return null;
        }
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof ScheduledMeasurement) {
            ScheduledMeasurement m = (ScheduledMeasurement)rhs;
            return this.derivedID.equals(m.derivedID);
        }
        return false;
    }

    public int hashCode() {
        return this.derivedID.hashCode();
    }

    public long getLastCollected() {
        return this.lastCollected;
    }

    public void setLastCollected(long lastCollected) {
        this.lastCollected = lastCollected;
    }
}

