/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.ntp;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.StringUtil;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.ExecuteWatchdog;
import org.hyperic.util.exec.PumpStreamHandler;

public class NTPDCollector
extends Collector {
    static final String PROP_NTPDC = "ntpdc";
    static final String PROP_INCLUDELOCAL = "includeLocal";
    static final String PROP_LOCAL = "LOCAL(0)";
    private static final String[] ARGS = new String[]{"-c", "sysinfo", "-c", "sysstats", "-c", "peers"};

    public boolean isPoolable() {
        return true;
    }

    private String getNtpdc() {
        return this.getProperties().getProperty(PROP_NTPDC, "");
    }

    private String getHostname() {
        return this.getProperties().getProperty("hostname", "");
    }

    protected void init() throws PluginException {
        String ntpdc = this.getNtpdc();
        if (!new File(ntpdc).exists()) {
            throw new PluginException("ntpdc=" + ntpdc + " does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collect() {
        String ntpdc = this.getNtpdc();
        int timeout = this.getTimeoutMillis();
        String host = this.getHostname();
        Boolean hasHost = false;
        int initialArraySize = 3;
        if (!host.equals("")) {
            initialArraySize = 4;
            hasHost = true;
        }
        String[] argv = new String[ARGS.length + initialArraySize];
        argv[0] = ntpdc;
        argv[1] = "-c";
        argv[2] = "'timeout " + timeout + "'";
        System.arraycopy(ARGS, 0, argv, 3, ARGS.length);
        if (hasHost.booleanValue()) {
            argv[argv.length - 1] = host;
        }
        boolean includeLocal = "true".equals(this.getCollectorProperty(PROP_INCLUDELOCAL, "false"));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecuteWatchdog wdog = new ExecuteWatchdog(15000);
        Execute exec = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)output), wdog);
        exec.setCommandline(argv);
        try {
            int exitStatus = exec.execute();
            if (exitStatus != 0 || wdog.killedProcess()) {
                this.setErrorMessage(ntpdc + " command failed");
                return;
            }
        }
        catch (Exception e) {
            this.setErrorMessage("Unable to exec process: " + e);
            return;
        }
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new StringReader(output.toString()));
            boolean seenPeerHeader = false;
            double peers = 0.0;
            double peerDelay = 0.0;
            double peerOffset = 0.0;
            double peerDisp = 0.0;
            double peersReachable = 0.0;
            double peersUnreachable = 0.0;
            double peersWithProbs = 0.0;
            double clientmode = 0.0;
            double sendingbroadcasts = 0.0;
            double receivingbroadcasts = 0.0;
            double peerssynchronized = 0.0;
            while ((line = in.readLine()) != null) {
                String[] exploded;
                if (line.startsWith("========")) {
                    seenPeerHeader = true;
                    continue;
                }
                if (line.startsWith("jitter:")) {
                    exploded = StringUtil.explodeQuoted((String)line);
                    if (exploded.length < 2) {
                        this.setErrorMessage("Unable to parse ntpdc output for jitter: ");
                        return;
                    }
                    this.setValue("Jitter", Double.parseDouble(exploded[1]));
                } else if (line.startsWith("system uptime:") || line.startsWith("time since restart:")) {
                    exploded = StringUtil.explodeQuoted((String)line);
                    if (exploded.length < 1) {
                        this.setErrorMessage("Unable to parse ntpdc output for system uptime: ");
                        return;
                    }
                    this.setValue("Uptime", Double.parseDouble(exploded[exploded.length - 1]));
                } else if (line.startsWith("time since reset:")) {
                    exploded = StringUtil.explodeQuoted((String)line);
                    if (exploded.length < 4) {
                        this.setErrorMessage("Unable to parse ntpdc output for time since reset: ");
                        return;
                    }
                    this.setValue("TimeSinceReset", Double.parseDouble(exploded[3]));
                } else if (seenPeerHeader) {
                    exploded = StringUtil.explodeQuoted((String)line);
                    if (exploded.length < 8) {
                        this.setErrorMessage("Unable to parse ntpdc output for seenPeerHeader: ");
                        return;
                    }
                    if (exploded[0].length() > PROP_LOCAL.length() && exploded[0].substring(1, PROP_LOCAL.length() + 1).equals(PROP_LOCAL) && !includeLocal) continue;
                    String status = exploded[0].substring(0, 1);
                    if (status.equals("=")) {
                        clientmode += 1.0;
                    } else if (status.equals("^")) {
                        receivingbroadcasts += 1.0;
                    } else if (status.equals("~")) {
                        sendingbroadcasts += 1.0;
                    } else if (status.equals("*")) {
                        peerssynchronized += 1.0;
                    }
                    peers += 1.0;
                    String reach = exploded[4];
                    if (reach.equals("377")) {
                        peersReachable += 1.0;
                    } else if (reach.equals("000") || reach.equals("0")) {
                        peersUnreachable += 1.0;
                    } else {
                        peersWithProbs += 1.0;
                    }
                    double delay = Double.parseDouble(exploded[5]);
                    double offset = Double.parseDouble(exploded[6]);
                    double disp = Double.parseDouble(exploded[7]);
                    peerDelay += Math.abs(delay);
                    peerOffset += Math.abs(offset);
                    peerDisp += Math.abs(disp);
                    continue;
                }
                if (!line.startsWith("stratum:")) continue;
                exploded = StringUtil.explodeQuoted((String)line);
                if (exploded.length < 2) {
                    this.setErrorMessage("Unable to parse ntpdc output for stratum: ");
                    return;
                }
                this.setValue("Stratum", Double.parseDouble(exploded[1]));
            }
            this.setValue("PeersReachable", peersReachable);
            this.setValue("PeersUnreachable", peersUnreachable);
            this.setValue("PeersWithReachabilityProblems", peersWithProbs);
            this.setValue("Peers", peers);
            this.setValue("PeerAverageDelay", peerDelay / peers);
            this.setValue("PeerAverageOffset", peerOffset / peers);
            this.setValue("PeerAverageDisplacement", peerDisp / peers);
            this.setValue("PeerAverageDisp", peerDisp / peers);
            this.setValue("PeersPolledClientMode", clientmode);
            this.setValue("PeersReceivingBroadcasts", receivingbroadcasts);
            this.setValue("PeersSendingBroadcasts", sendingbroadcasts);
            this.setValue("PeersSynchronized", peerssynchronized);
            return;
        }
        catch (IllegalArgumentException e) {
            this.setErrorMessage("Unable to parse ntpdc output: " + e);
            return;
        }
        catch (IOException e) {
            this.setErrorMessage("Unable to process ntpdc output: " + e);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

