/*
 * Decompiled with CFR 0.152.
 */
package com.hyperic.hq.rt.agent.server;

import com.hyperic.hq.bizapp.client.RtCallbackClient;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentStorageException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.StorageProviderFetcher;
import org.hyperic.hq.product.RtStat;

class RtSenderThread
implements Runnable {
    private static final int PROP_RECSIZE = 2048;
    private static final int SEND_INTERVAL = 60000;
    private static final int MAX_BATCHSIZE = 1000;
    private static final String DATA_LISTNAME = "rt_spool";
    private volatile boolean _shouldDie = false;
    private Log _log = LogFactory.getLog(RtSenderThread.class);
    private RtCallbackClient _client;
    private AgentStorageProvider _storage;
    private LinkedList _transitionQueue;

    RtSenderThread(Properties bootProps, AgentStorageProvider storage) throws AgentStartException {
        this._storage = storage;
        this._client = this.setupClient();
        this._transitionQueue = new LinkedList();
        String info = bootProps.getProperty(DATA_LISTNAME);
        if (info != null) {
            this._storage.addOverloadedInfo(DATA_LISTNAME, info);
        }
        try {
            this._storage.createList(DATA_LISTNAME, 2048);
        }
        catch (AgentStorageException ignore) {
            // empty catch block
        }
    }

    private RtCallbackClient setupClient() throws AgentStartException {
        StorageProviderFetcher fetcher = new StorageProviderFetcher(this._storage);
        return new RtCallbackClient((ProviderFetcher)fetcher);
    }

    void die() {
        this._shouldDie = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processData(Collection lst) {
        for (RtStat rec : lst) {
            String encoded;
            try {
                encoded = rec.encode();
            }
            catch (IOException e) {
                this._log.error((Object)("Unable to encode data: " + e));
                continue;
            }
            LinkedList linkedList = this._transitionQueue;
            synchronized (linkedList) {
                this._transitionQueue.add(encoded);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransitionQueue() {
        LinkedList linkedList = this._transitionQueue;
        synchronized (linkedList) {
            Iterator i = this._transitionQueue.iterator();
            while (i.hasNext()) {
                String val = (String)i.next();
                i.remove();
                try {
                    this._storage.addToList(DATA_LISTNAME, val);
                }
                catch (Exception exc) {
                    this._log.error((Object)"Unable to store data", (Throwable)exc);
                }
            }
            try {
                this._storage.flush();
            }
            catch (Exception exc) {
                this._log.error((Object)"Unable to flush storage", (Throwable)exc);
            }
        }
    }

    public void run() {
        while (!this._shouldDie) {
            int j;
            int numUsed;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException exc) {
                this._log.info((Object)"Rt sender interrupted");
                return;
            }
            this.processTransitionQueue();
            LinkedList<RtStat> lst = new LinkedList<RtStat>();
            Iterator i = this._storage.getListIterator(DATA_LISTNAME);
            for (numUsed = 0; i != null && i.hasNext() && numUsed < 1000; ++numUsed) {
                RtStat rec;
                try {
                    rec = RtStat.decode((String)((String)i.next()));
                }
                catch (IOException exc) {
                    this._log.error((Object)("Error accessing record -- deleting: " + exc));
                    continue;
                }
                lst.add(rec);
            }
            if (numUsed == 0) continue;
            this._log.debug((Object)("Sending " + numUsed + " Response time entries " + "to server"));
            boolean success = false;
            try {
                this._client.RtSendReport(lst);
                success = true;
            }
            catch (AgentCallbackClientException exc) {
                this._log.error((Object)("Error sending RT data to server: " + exc.getMessage()));
            }
            if (!success) continue;
            Iterator i2 = this._storage.getListIterator(DATA_LISTNAME);
            for (j = 0; i2 != null && i2.hasNext() && j < numUsed; ++j) {
                i2.next();
                i2.remove();
            }
            try {
                this._storage.flush();
            }
            catch (AgentStorageException exc) {
                this._log.error((Object)"Failed to flush agent storage", (Throwable)exc);
            }
            if (j == numUsed) continue;
            this._log.error((Object)("Failed to remove " + (numUsed - j) + "records"));
        }
    }
}

