/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.iis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hyperic.hq.plugin.iis.IisMeasurementPlugin;
import org.hyperic.hq.plugin.iis.IisMetaBase;
import org.hyperic.hq.plugin.iis.IisRtPlugin;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.RegistryServerDetector;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;

public class IisDetector
extends ServerDetector
implements RegistryServerDetector {
    static final String VHOST_NAME = "VHost";
    private static final String REG_INET = "SOFTWARE\\Microsoft\\InetStp";
    private static final String REG_INET_MAJORVER = "MajorVersion";
    private static final String REG_INET_MINORVER = "MinorVersion";
    private static final String PDH_WEB_SERVICE = "Web Service";
    private static final String PDH_TOTAL = "_Total";

    public List getServerResources(ConfigResponse platformConfig, String path, RegistryKey current) throws PluginException {
        String pluginVersion = this.getTypeInfo().getVersion();
        path = IisDetector.getParentDir((String)path);
        try {
            RegistryKey versionInfo = RegistryKey.LocalMachine.openSubKey(REG_INET);
            int majorVersion = versionInfo.getIntValue(REG_INET_MAJORVER);
            int minorVersion = versionInfo.getIntValue(REG_INET_MINORVER);
            String version = majorVersion + ".x";
            if (!pluginVersion.equals(version)) {
                return null;
            }
            ServerResource server = this.createServerResource(path);
            server.setControlConfig();
            this.setProductConfig(server, new ConfigResponse());
            this.setMeasurementConfig(server, new ConfigResponse());
            ConfigResponse cprops = new ConfigResponse();
            cprops.setValue("version", majorVersion + "." + minorVersion);
            server.setCustomProperties(cprops);
            ArrayList<ServerResource> serverList = new ArrayList<ServerResource>();
            serverList.add(server);
            return serverList;
        }
        catch (Win32Exception e) {
            return null;
        }
    }

    private ConfigResponse getMeasurementConfig(IisMetaBase info) {
        ConfigResponse config = new ConfigResponse();
        config.setValue("port", info.port);
        config.setValue("hostname", info.ip);
        if (info.hostname != null) {
            config.setValue("hostheader", info.hostname);
        }
        config.setValue("ssl", info.requireSSL);
        config.setValue("protocol", this.getConnectionProtocol(info.port));
        return config;
    }

    private Map getWebSites() {
        try {
            return IisMetaBase.getWebSites();
        }
        catch (Win32Exception e) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        return new HashMap();
    }

    protected List discoverServices(ConfigResponse config) throws PluginException {
        ArrayList<String> vhosts = new ArrayList<String>();
        String installpath = config.getValue("installpath");
        try {
            String[] instances = Pdh.getInstances((String)PDH_WEB_SERVICE);
            for (int i = 0; i < instances.length; ++i) {
                if (instances[i].equals(PDH_TOTAL)) continue;
                vhosts.add(instances[i]);
            }
        }
        catch (Win32Exception e) {
            throw new PluginException("Error getting PDH data: " + e.getMessage(), (Throwable)e);
        }
        Map websites = this.getWebSites();
        boolean hasWebsites = websites.size() != 0;
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        for (int i = 0; i < vhosts.size(); ++i) {
            ConfigResponse metricProps;
            String siteName = (String)vhosts.get(i);
            ServiceResource service = new ServiceResource();
            service.setType((GenericPlugin)this, VHOST_NAME);
            service.setServiceName(siteName);
            IisMetaBase info = (IisMetaBase)websites.get(siteName);
            ConfigResponse cprops = new ConfigResponse();
            Properties rtProps = new Properties();
            if (info != null) {
                metricProps = this.getMeasurementConfig(info);
                if (info.path != null) {
                    cprops.setValue("docroot", info.path);
                }
            } else {
                if (hasWebsites) {
                    this.getLog().debug((Object)("Configuration not found for site: " + siteName));
                    continue;
                }
                metricProps = new ConfigResponse();
            }
            metricProps.setValue(IisMeasurementPlugin.PROP_IISHOST, siteName);
            if (info != null) {
                rtProps.setProperty(IisRtPlugin.CONFIG_LOGDIR, "C:\\Windows\\System32\\LogFiles\\W3SVC" + info.id);
            }
            rtProps.setProperty(IisRtPlugin.CONFIG_INTERVAL, "60");
            rtProps.setProperty(IisRtPlugin.CONFIG_LOGMASK, "*.log");
            service.setProductConfig();
            this.setMeasurementConfig(service, metricProps);
            service.setCustomProperties(cprops);
            services.add(service);
        }
        return services;
    }
}

