/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.postgresql;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.postgresql.ResourceControl;
import org.hyperic.hq.product.PluginException;

public class DataBaseControlPlugin
extends ResourceControl {
    private static Log log = LogFactory.getLog(DataBaseControlPlugin.class);

    public void doAction(String action, String[] args) throws PluginException {
        String query = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[doAction] action='" + action + "' args=" + Arrays.asList(args)));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]).append(" ");
        }
        String opt = sb.toString().trim();
        if (action.equals("Analyze")) {
            query = "ANALYZE " + opt;
        } else if (action.equals("Vacuum")) {
            query = "VACUUM " + opt;
        } else if (action.equals("VacuumAnalyze")) {
            query = "VACUUM " + opt + " ANALYZE ";
        } else if (action.equals("Reindex")) {
            query = "REINDEX DATABASE " + this.db + " " + opt;
        }
        if (query == null) {
            throw new PluginException("Action '" + action + "' not supported");
        }
        log.debug((Object)("[doAction] query=" + query));
        this.execute(query);
    }
}

