/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.postgresql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.postgresql.PostgreSQL;
import org.hyperic.hq.product.Collector;
import org.hyperic.util.jdbc.DBUtil;

public class ServerCollector
extends Collector {
    private static Log log = LogFactory.getLog(ServerCollector.class);
    private String connectionQ = "select count(datid) as connections,(SELECT setting AS mc FROM pg_settings WHERE name = 'max_connections') as max_connections from pg_stat_activity";
    private String statsQ = "SELECT SUM(xact_commit) as xact_commit, SUM(xact_rollback) as xact_rollback, SUM(blks_read) as blks_read, SUM(blks_hit) as blks_hit, SUM(tup_fetched) as tup_fetched, SUM(tup_inserted) as tup_inserted, SUM(tup_updated) as tup_updated, SUM(tup_deleted) as tup_deleted FROM pg_stat_database where datname in (SELECT datname FROM pg_database WHERE datistemplate IS FALSE AND datallowconn IS TRUE)";
    private String[] queries = new String[]{"select count(*) AS idle_backends from pg_stat_activity where current_query = '<IDLE>'"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect() {
        Properties p = this.getProperties();
        String user = p.getProperty("postgresql.user");
        String pass = p.getProperty("postgresql.pass");
        Connection conn = null;
        try {
            String url = PostgreSQL.prepareUrl(p, null);
            log.debug((Object)("[collect] url:'" + url + "'"));
            conn = DriverManager.getConnection(url, user, pass);
            for (int j = 0; j < this.queries.length; ++j) {
                this.extartMetrics(this.queries[j], conn);
            }
            this.getPGTOPStast(conn);
            this.getConnectionsMetrics(conn);
        }
        catch (Exception e) {
            try {
                String msg = "Error getting metrics: " + e.getMessage();
                this.setErrorMessage(msg, e);
                log.debug((Object)("[collect] " + msg), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)log, conn, null, null);
                throw throwable;
            }
            DBUtil.closeJDBCObjects((Object)log, (Connection)conn, null, null);
        }
        DBUtil.closeJDBCObjects((Object)log, (Connection)conn, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPGTOPStast(Connection conn) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            log.debug((Object)("[getConnectionsMetrics] query:'" + this.connectionQ + "'"));
            stmt = conn.createStatement();
            rs = stmt.executeQuery(this.statsQ);
            while (rs.next()) {
                double blksHit;
                double blksRead = rs.getDouble("blks_read");
                double blksHitP = blksRead + (blksHit = rs.getDouble("blks_hit")) > 0.0 ? blksHit / (blksRead + blksHit) : 0.0;
                double tupAltered = rs.getDouble("tup_inserted") + rs.getDouble("tup_updated") + rs.getDouble("tup_deleted");
                this.setValue("xact_commit", rs.getDouble("xact_commit"));
                this.setValue("xact_rollback", rs.getDouble("xact_rollback"));
                this.setValue("blks_read", blksRead);
                this.setValue("blks_hit", blksHit);
                this.setValue("blks_hit_p", blksHitP);
                this.setValue("tup_fetched", rs.getDouble("tup_fetched"));
                this.setValue("tup_altered", tupAltered);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeJDBCObjects((Object)log, null, stmt, rs);
            throw throwable;
        }
        DBUtil.closeJDBCObjects((Object)log, null, (Statement)stmt, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConnectionsMetrics(Connection conn) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            log.debug((Object)("[getConnectionsMetrics] query:'" + this.connectionQ + "'"));
            stmt = conn.createStatement();
            rs = stmt.executeQuery(this.connectionQ);
            while (rs.next()) {
                double c = rs.getDouble("connections");
                double m = rs.getDouble("max_connections");
                this.setValue("connections", c);
                this.setValue("connections_usage", c / m);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeJDBCObjects((Object)log, null, stmt, rs);
            throw throwable;
        }
        DBUtil.closeJDBCObjects((Object)log, null, (Statement)stmt, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extartMetrics(String query, Connection conn) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            log.debug((Object)("[extartMetrics] query:'" + query + "'"));
            stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            ResultSetMetaData md = rs.getMetaData();
            while (rs.next()) {
                for (int c = 1; c <= md.getColumnCount(); ++c) {
                    this.setValue(md.getColumnLabel(c), rs.getString(c));
                }
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeJDBCObjects((Object)log, null, stmt, rs);
            throw throwable;
        }
        DBUtil.closeJDBCObjects((Object)log, null, (Statement)stmt, (ResultSet)rs);
    }
}

