/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.postgresql;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerControlPlugin;
import org.hyperic.util.config.ConfigResponse;

public class ServerControl
extends ServerControlPlugin {
    private static Log log = LogFactory.getLog(ServerControl.class);

    public void configure(ConfigResponse config) throws PluginException {
        log.info((Object)("[configure] config=" + config));
        String program = config.getValue("postgresql.program");
        File programFile = new File(program);
        if (!programFile.isAbsolute()) {
            programFile = new File(config.getValue("installpath"), program);
        }
        if (!programFile.exists()) {
            throw new PluginException("Control error: program '" + program + "' not found");
        }
        config.setValue("program", program);
        config.setValue("timeout", config.getValue("postgresql.timeout"));
        config.setValue("prefix", config.getValue("postgresql.prefix"));
        super.configure(config);
    }

    public void start() {
        log.info((Object)"[start]");
        String[] args = new String[]{"start"};
        this.doCommand(args);
    }

    public void stop() {
        log.info((Object)"[stop]");
        String[] args = new String[]{"stop"};
        this.doCommand(args);
    }

    public void restart() {
        log.info((Object)"[restart]");
        String[] args = new String[]{"restart"};
        this.doCommand(args);
    }
}

