/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.postgresql;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.postgresql.ResourceMeasurement;
import org.hyperic.hq.product.Metric;

public class TableMeasurementPlugin
extends ResourceMeasurement {
    private static Log log = LogFactory.getLog(TableMeasurementPlugin.class);

    protected String getQuery(Metric metric) {
        String tableName = metric.getObjectProperties().getProperty("table");
        String schemaName = metric.getObjectProperties().getProperty("schema");
        String attributeName = metric.getAttributeName();
        if (metric.isAvail()) {
            attributeName = "seq_scan";
        }
        String tableQuery = null;
        tableQuery = attributeName.equals("DataSpaceUsed") ? "SELECT SUM(relpages) * 8 FROM pg_class JOIN pg_catalog.pg_namespace n ON n.oid = pg_class.relnamespace WHERE pg_class.relname = '" + tableName + "' " + "AND n.nspname ='" + schemaName + "'" : (attributeName.equals("IndexSpaceUsed") ? "SELECT SUM(relpages) * 8 FROM pg_class JOIN pg_catalog.pg_namespace n ON n.oid = pg_class.relnamespace WHERE n.nspname = '" + schemaName + "' " + "AND relname IN (SELECT indexrelname FROM " + "pg_stat_user_indexes WHERE relname='" + tableName + "' AND schemaname='" + schemaName + "')" : "SELECT " + attributeName + " FROM pg_stat_user_tables " + "WHERE relname='" + tableName + "' " + "AND schemaname='" + schemaName + "'");
        log.debug((Object)("[getQuery] tableQuery='" + tableQuery + "'"));
        return tableQuery;
    }
}

