/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.db2;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.db2monitor.DB2Monitor;
import org.hyperic.db2monitor.DB2MonitorException;
import org.hyperic.db2monitor.SqlmDbase;
import org.hyperic.db2monitor.SqlmTable;
import org.hyperic.db2monitor.SqlmTablespace;
import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.appdef.shared.AIServerExtValue;
import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.hq.appdef.shared.AIServiceValue;
import org.hyperic.hq.plugin.db2.DB2ProductPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.RuntimeDiscoverer;
import org.hyperic.hq.product.RuntimeResourceReport;
import org.hyperic.util.config.ConfigResponse;

public class DB2RuntimeAutoDiscoveryPlugin
implements RuntimeDiscoverer {
    private Log log = LogFactory.getLog((String)"DB2RuntimeAutoDiscoveryPlugin");
    private String version;
    private DB2Monitor db2Monitor = null;

    public DB2RuntimeAutoDiscoveryPlugin(String version) {
        this.version = version;
    }

    public RuntimeResourceReport discoverResources(int serverId, AIPlatformValue aiplatform, ConfigResponse config) throws PluginException {
        SqlmDbase[] dbase;
        String monEnable;
        try {
            DB2Monitor.load();
        }
        catch (UnsatisfiedLinkError le) {
            throw new PluginException(le.getMessage());
        }
        catch (DB2MonitorException e) {
            throw new PluginException(e.getMessage());
        }
        RuntimeResourceReport rrr = new RuntimeResourceReport(serverId);
        if (this.db2Monitor == null) {
            String nodename = config.getValue("nodename");
            String user = config.getValue("user", "");
            String password = config.getValue("password", "");
            try {
                if (nodename != null) {
                    this.log.debug((Object)("Attaching to instance: " + nodename));
                    this.db2Monitor = new DB2Monitor(nodename, user, password);
                } else {
                    this.log.debug((Object)"Attaching to default local instance");
                    this.db2Monitor = new DB2Monitor();
                }
            }
            catch (DB2MonitorException e) {
                this.log.error((Object)("Error attaching to DB2 instance: " + e.getMessage()));
            }
            if (this.db2Monitor == null) {
                throw new PluginException("DB2 Monitor not loaded");
            }
        }
        if ((monEnable = config.getValue("enableMon")) != null) {
            try {
                this.log.debug((Object)"Enabling DB2 monitoring switches");
                this.db2Monitor.enableMonitorSwitches();
            }
            catch (DB2MonitorException e) {
                this.log.error((Object)("Unable to enable DB2 monitor switches: " + e.getMessage()));
            }
        }
        try {
            dbase = this.db2Monitor.getSqlmDbase();
        }
        catch (DB2MonitorException e) {
            throw new PluginException(e.getMessage());
        }
        AIServerExtValue server = new AIServerExtValue();
        server.setId(new Integer(serverId));
        server.setPlaceholder(true);
        ArrayList<AIServiceValue> services = new ArrayList<AIServiceValue>();
        for (int i = 0; i < dbase.length; ++i) {
            AIServiceValue service = new AIServiceValue();
            String dbName = dbase[i].getName();
            if (this.version.equals("7.x")) {
                service.setServiceTypeName(DB2ProductPlugin.FULL_DATABASE_NAME_V7);
            } else if (this.version.equals("8.x")) {
                service.setServiceTypeName(DB2ProductPlugin.FULL_DATABASE_NAME_V8);
            } else {
                service.setServiceTypeName(DB2ProductPlugin.FULL_DATABASE_NAME_V9);
            }
            service.setName("%serverName% " + dbName + " " + "Database");
            ConfigResponse productResponse = new ConfigResponse();
            ConfigResponse metricResponse = new ConfigResponse();
            try {
                metricResponse.setValue("database", dbName);
                service.setProductConfig(productResponse.encode());
                service.setMeasurementConfig(metricResponse.encode());
            }
            catch (Exception exc) {
                throw new PluginException("Unable to generate config");
            }
            ArrayList tables = this.discoverTables(dbName);
            services.addAll(tables);
            ArrayList tablespaces = this.discoverTablespaces(dbName);
            services.addAll(tablespaces);
            services.add(service);
        }
        server.setAIServiceValues(services.toArray(new AIServiceValue[0]));
        aiplatform.addAIServerValue((AIServerValue)server);
        rrr.addAIPlatform(aiplatform);
        return rrr;
    }

    private ArrayList discoverTables(String dbName) throws PluginException {
        SqlmTable[] tables;
        ArrayList<AIServiceValue> services = new ArrayList<AIServiceValue>();
        try {
            tables = this.db2Monitor.getSqlmTable(dbName);
        }
        catch (UnsatisfiedLinkError e) {
            throw new PluginException(e.getMessage());
        }
        catch (DB2MonitorException e) {
            throw new PluginException(e.getMessage());
        }
        for (int i = 0; i < tables.length; ++i) {
            AIServiceValue service = new AIServiceValue();
            String tableName = tables[i].getName();
            if (this.version.equals("7.x")) {
                service.setServiceTypeName(DB2ProductPlugin.FULL_TABLE_NAME_V7);
            } else if (this.version.equals("8.x")) {
                service.setServiceTypeName(DB2ProductPlugin.FULL_TABLE_NAME_V8);
            } else {
                service.setServiceTypeName(DB2ProductPlugin.FULL_TABLE_NAME_V9);
            }
            service.setName("%serverName% " + dbName + " " + tableName + " " + "Table");
            ConfigResponse productResponse = new ConfigResponse();
            ConfigResponse metricResponse = new ConfigResponse();
            try {
                metricResponse.setValue("database", dbName);
                metricResponse.setValue("table", tableName);
                service.setProductConfig(productResponse.encode());
                service.setMeasurementConfig(metricResponse.encode());
            }
            catch (Exception exc) {
                throw new PluginException("Unable to generate config");
            }
            services.add(service);
        }
        return services;
    }

    private ArrayList discoverTablespaces(String dbName) throws PluginException {
        SqlmTablespace[] ts;
        ArrayList<AIServiceValue> services = new ArrayList<AIServiceValue>();
        try {
            ts = this.db2Monitor.getSqlmTablespace(dbName);
        }
        catch (UnsatisfiedLinkError e) {
            throw new PluginException(e.getMessage());
        }
        catch (DB2MonitorException e) {
            throw new PluginException(e.getMessage());
        }
        for (int i = 0; i < ts.length; ++i) {
            AIServiceValue service = new AIServiceValue();
            String tsName = ts[i].getName();
            if (this.version.equals("7.x")) {
                service.setServiceTypeName(DB2ProductPlugin.FULL_TABLESPACE_NAME_V7);
            } else if (this.version.equals("8.x")) {
                service.setServiceTypeName(DB2ProductPlugin.FULL_TABLESPACE_NAME_V8);
            } else {
                service.setServiceTypeName(DB2ProductPlugin.FULL_TABLESPACE_NAME_V9);
            }
            service.setName("%serverName% " + dbName + " " + tsName + " " + "Tablespace");
            ConfigResponse productResponse = new ConfigResponse();
            ConfigResponse metricResponse = new ConfigResponse();
            try {
                metricResponse.setValue("database", dbName);
                metricResponse.setValue("tablespace", tsName);
                service.setProductConfig(productResponse.encode());
                service.setMeasurementConfig(metricResponse.encode());
            }
            catch (Exception exc) {
                throw new PluginException("Unable to generate config");
            }
            services.add(service);
        }
        return services;
    }
}

