/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HypericEnum
implements Serializable {
    private static final Log _log = LogFactory.getLog(HypericEnum.class);
    private static final boolean DEBUG_ENUMS = false;
    private static final Map _enumsByClass = new HashMap();
    private Class _implClass;
    private int _code;
    private transient String _desc;
    private transient String _localeProp;
    private transient ResourceBundle _bundle;
    private static Comparator CODE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            HypericEnum e1 = (HypericEnum)o1;
            HypericEnum e2 = (HypericEnum)o2;
            if (e1.getCode() < e2.getCode()) {
                return -1;
            }
            if (e1.getCode() == e2.getCode()) {
                return 0;
            }
            return 1;
        }
    };

    protected HypericEnum(int code, String desc, String localeProp, ResourceBundle bundle) {
        this.init(this.getClass(), code, desc, localeProp, bundle);
    }

    protected HypericEnum(Class c, int code, String desc, String localeProp, ResourceBundle bundle) {
        this.init(c, code, desc, localeProp, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Class c, int code, String desc, String localeProp, ResourceBundle bundle) {
        this._implClass = c;
        this._code = code;
        this._desc = desc;
        this._localeProp = localeProp;
        this._bundle = bundle;
        if (this._bundle == null) {
            _log.warn((Object)("Unable to find bundle when creating enum for [" + this._implClass + "]"));
        }
        Map map = _enumsByClass;
        synchronized (map) {
            HashSet<HypericEnum> vals = (HashSet<HypericEnum>)_enumsByClass.get(this._implClass);
            if (vals == null) {
                vals = new HashSet<HypericEnum>();
                _enumsByClass.put(this._implClass, vals);
            }
            vals.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void unregister() {
        Map map = _enumsByClass;
        synchronized (map) {
            Set vals = (Set)_enumsByClass.get(this._implClass);
            vals.remove(this);
        }
    }

    public int getCode() {
        return this._code;
    }

    public String getValue() {
        if (this._bundle == null) {
            return "** No bundle for class " + this._implClass + " **";
        }
        String res = this._bundle.getString(this._localeProp);
        if (res == null) {
            return "** Property [" + this._localeProp + "] not found in bundle [" + this._bundle.toString() + "]";
        }
        return res;
    }

    public String getDescription() {
        return this._desc;
    }

    public String toString() {
        return this._desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HypericEnum getByCode(Class c, int code) {
        Map map = _enumsByClass;
        synchronized (map) {
            Set vals = (Set)_enumsByClass.get(c);
            if (vals != null) {
                for (HypericEnum e : vals) {
                    if (e.getCode() != code) continue;
                    return e;
                }
            }
        }
        return null;
    }

    public static HypericEnum findByCode(Class c, int code) {
        HypericEnum res = HypericEnum.getByCode(c, code);
        if (res != null) {
            return res;
        }
        throw new IllegalStateException("Unknown Enum Class [" + c.getName() + "] code=" + code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HypericEnum findByDescription(Class c, String description) {
        Map map = _enumsByClass;
        synchronized (map) {
            Set vals = (Set)_enumsByClass.get(c);
            if (vals != null) {
                for (HypericEnum e : vals) {
                    if (!e.getDescription().equals(description)) continue;
                    return e;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> getAll(Class<T> c) {
        Set vals;
        Map map = _enumsByClass;
        synchronized (map) {
            vals = (Set)_enumsByClass.get(c);
        }
        if (vals == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList res = new ArrayList(vals);
        Collections.sort(res, CODE_COMPARATOR);
        return Collections.unmodifiableList(res);
    }

    private Object readResolve() throws ObjectStreamException {
        return HypericEnum.findByCode(this._implClass, this._code);
    }
}

