/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import org.hyperic.util.config.BooleanConfigOption;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.DoubleConfigOption;
import org.hyperic.util.config.EnumerationConfigOption;
import org.hyperic.util.config.IntegerConfigOption;
import org.hyperic.util.config.PortConfigOption;
import org.hyperic.util.config.RegexArrayConfigOption;
import org.hyperic.util.config.StringArrayConfigOption;
import org.hyperic.util.config.StringConfigOption;

public class SchemaBuilder {
    private ConfigSchema schema;
    private ConfigResponse config;

    public SchemaBuilder(ConfigSchema schema, ConfigResponse config) {
        this.schema = schema;
        this.config = config;
    }

    public SchemaBuilder(ConfigResponse config) {
        this(new ConfigSchema(), config);
    }

    public SchemaBuilder() {
        this(new ConfigResponse());
    }

    public ConfigSchema getSchema() {
        return this.schema;
    }

    public ConfigOption add(String prop, String description, String defaultValue, boolean optional) {
        StringConfigOption opt = new StringConfigOption(prop, description, defaultValue);
        opt.setOptional(optional);
        return this.addOption(opt);
    }

    public ConfigOption add(String prop, String description, String defaultValue) {
        return this.add(prop, description, defaultValue, false);
    }

    public ConfigOption add(String prop, String description, int defaultValue) {
        return this.add(prop, description, new Integer(defaultValue));
    }

    public ConfigOption add(String prop, String description, Integer defaultValue) {
        return this.addOption(new IntegerConfigOption(prop, description, defaultValue));
    }

    public ConfigOption add(String prop, String description, double defaultValue) {
        return this.add(prop, description, new Double(defaultValue));
    }

    public ConfigOption add(String prop, String description, Double defaultValue) {
        return this.addOption(new DoubleConfigOption(prop, description, defaultValue));
    }

    public ConfigOption add(String prop, String description, boolean defaultValue) {
        return this.addOption(new BooleanConfigOption(prop, description, defaultValue));
    }

    public ConfigOption addSecret(String prop, String description) {
        StringConfigOption opt = new StringConfigOption(prop, description, null);
        opt.setSecret(true);
        return this.addOption(opt);
    }

    public ConfigOption addPort(String prop, String description, int defaultValue) {
        return this.addPort(prop, description, new Integer(defaultValue));
    }

    public ConfigOption addPort(String prop, String description, Integer defaultValue) {
        return this.addOption(new PortConfigOption(prop, description, defaultValue));
    }

    public ConfigOption addEnum(String prop, String description, String[] opts) {
        return this.addEnum(prop, description, opts, opts[0]);
    }

    public ConfigOption addEnum(String prop, String description, String[] opts, String defaultValue) {
        return this.addOption(new EnumerationConfigOption(prop, description, defaultValue, opts));
    }

    public ConfigOption addRegex(String prop, String description, String defaultValue) {
        return this.addOption(new RegexArrayConfigOption(prop, description, defaultValue));
    }

    public ConfigOption addStringArray(String prop, String description, String defaultValue) {
        return this.addOption(new StringArrayConfigOption(prop, description, defaultValue));
    }

    public ConfigOption add(String[] opt) {
        return this.add(opt[0], opt[1], opt[2]);
    }

    private ConfigOption addOption(ConfigOption opt) {
        this.setDefault(opt);
        this.schema.addOption(opt);
        return opt;
    }

    private void setDefault(ConfigOption opt) {
        String defaultValue = this.config.getValue(opt.getName());
        if (defaultValue != null) {
            opt.setDefault(defaultValue);
        }
    }
}

