/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.exec;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tanukisoftware.wrapper.WrapperManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ShutdownType {
    Restart(12){

        protected final void executeNormalShutdown() {
            m_logger.error((Object)"Restart was requested but Wrapper watchdog was not detected - please restart manually!!");
            super.executeNormalShutdown();
        }

        protected final void executeWrapperManagedShutdown() {
            WrapperManager.restartAndReturn();
        }
    }
    ,
    NormalStop(0){}
    ,
    AbnormalStop(-1){};

    private static final Log m_logger;
    private static Map<Integer, ShutdownType> m_mapReverseMapping;
    private int m_iExitCode;

    private ShutdownType(int iExitCode) {
        this.m_iExitCode = iExitCode;
    }

    public static final ShutdownType reverseValueOf(int iExitCode) {
        ShutdownType enumShutdownType = m_mapReverseMapping.get(iExitCode);
        return enumShutdownType == null ? NormalStop : enumShutdownType;
    }

    public void shutdown() {
        if (WrapperManager.isControlledByNativeWrapper()) {
            this.executeWrapperManagedShutdown();
        } else {
            this.executeNormalShutdown();
        }
    }

    protected void executeNormalShutdown() {
        System.exit(this.m_iExitCode);
    }

    protected void executeWrapperManagedShutdown() {
        WrapperManager.stopAndReturn((int)this.m_iExitCode);
    }

    public final int exitCode() {
        return this.m_iExitCode;
    }

    static {
        m_logger = LogFactory.getLog(ShutdownType.class);
        m_mapReverseMapping = new HashMap<Integer, ShutdownType>();
        for (ShutdownType enumShutdownType : ShutdownType.values()) {
            m_mapReverseMapping.put(enumShutdownType.m_iExitCode, enumShutdownType);
        }
    }
}

