/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.security;

import java.util.Random;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;

public class SecurityUtil {
    public static final String DEFAULT_ENCRYPTION_ALGORITHM = "PBEWithMD5AndDES";
    public static final String ENC_MARK_PREFIX = "ENC(";
    public static final String ENC_MARK_POSTFIX = ")";

    public static String generateRandomToken() {
        Random r = new Random(System.currentTimeMillis());
        long rand1 = Math.abs(r.nextLong());
        try {
            Thread.sleep(rand1 % 100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        long rand2 = r.nextLong();
        return System.currentTimeMillis() + "-" + Math.abs(rand1) + "-" + Math.abs(rand2);
    }

    public static boolean isMarkedEncrypted(String str) {
        if (str == null) {
            return false;
        }
        String uStr = str.toUpperCase();
        return uStr.startsWith(ENC_MARK_PREFIX) && uStr.endsWith(ENC_MARK_POSTFIX);
    }

    public static String unmark(String str) {
        return str.substring(ENC_MARK_PREFIX.length(), str.length() - ENC_MARK_POSTFIX.length());
    }

    public static String unmarkRecursive(String str) {
        while (str.startsWith(ENC_MARK_PREFIX)) {
            str = str.substring(ENC_MARK_PREFIX.length(), str.length() - ENC_MARK_POSTFIX.length());
        }
        return str;
    }

    public static String mark(String str) {
        return ENC_MARK_PREFIX + str + ENC_MARK_POSTFIX;
    }

    public static StandardPBEStringEncryptor getStandardPBEStringEncryptor(String pbePass) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setAlgorithm(DEFAULT_ENCRYPTION_ALGORITHM);
        encryptor.setPassword(pbePass);
        return encryptor;
    }

    public static String encrypt(StringEncryptor encryptor, String data) {
        return PropertyValueEncryptionUtils.encrypt((String)data, (StringEncryptor)encryptor);
    }

    public static String encrypt(String encryptionAlgorithm, String encryptionKey, String data) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword(encryptionKey);
        encryptor.setAlgorithm(encryptionAlgorithm);
        return SecurityUtil.encrypt((StringEncryptor)encryptor, data);
    }

    public static String decryptRecursiveUnmark(StringEncryptor encryptor, String data) {
        return encryptor.decrypt(SecurityUtil.unmarkRecursive(data.trim()));
    }

    public static String decrypt(StringEncryptor encryptor, String data) {
        return PropertyValueEncryptionUtils.decrypt((String)data, (StringEncryptor)encryptor);
    }

    public static String decrypt(String encryptionAlgorithm, String encryptionKey, String data) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword(encryptionKey);
        encryptor.setAlgorithm(encryptionAlgorithm);
        return SecurityUtil.decrypt((StringEncryptor)encryptor, data);
    }
}

