/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.units;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.hyperic.util.TimeUtil;
import org.hyperic.util.units.FormatSpecifics;
import org.hyperic.util.units.FormattedNumber;
import org.hyperic.util.units.Formatter;
import org.hyperic.util.units.ParseSpecifics;
import org.hyperic.util.units.UnitNumber;
import org.hyperic.util.units.UnitsUtil;

public class DateFormatter
implements Formatter {
    public FormattedNumber format(UnitNumber val, Locale locale) {
        DateSpecifics specifics = new DateSpecifics();
        specifics.setDateFormat(this.getDefaultFormat(locale));
        return this.format(val, locale, specifics);
    }

    public FormattedNumber format(UnitNumber val, Locale locale, FormatSpecifics specifics) {
        BigDecimal dec = val.getBaseValue().divide(UnitsUtil.FACT_MILLIS, 6);
        DateFormat df = specifics == null ? this.getDefaultFormat(locale) : ((DateSpecifics)specifics).getDateFormat();
        return new FormattedNumber(df.format(new Date(dec.longValue())), "");
    }

    public FormattedNumber[] formatSame(double[] val, int unitType, int scale, Locale locale) {
        FormattedNumber[] res = new FormattedNumber[val.length];
        for (int i = 0; i < val.length; ++i) {
            res[i] = this.format(new UnitNumber(val[i], unitType, scale), locale);
        }
        return res;
    }

    public FormattedNumber[] formatSame(double[] val, int unitType, int scale, Locale locale, FormatSpecifics specifics) {
        FormattedNumber[] res = new FormattedNumber[val.length];
        for (int i = 0; i < val.length; ++i) {
            res[i] = this.format(new UnitNumber(val[i], unitType, scale), locale, specifics);
        }
        return res;
    }

    private DateFormat getDefaultFormat(Locale locale) {
        return DateFormat.getDateTimeInstance(3, 2, locale);
    }

    public BigDecimal getBaseValue(double value, int scale) {
        return DateFormatter.getBaseTime(value, scale);
    }

    public BigDecimal getScaledValue(BigDecimal value, int targScale) {
        return DateFormatter.getScaledTime(value, targScale);
    }

    public static BigDecimal getScaledTime(BigDecimal value, int targScale) {
        return value.divide(DateFormatter.getScaleCoeff(targScale), 6);
    }

    public static BigDecimal getBaseTime(double value, int scale) {
        BigDecimal res = new BigDecimal(value);
        return res.multiply(DateFormatter.getScaleCoeff(scale));
    }

    private static BigDecimal getScaleCoeff(int scale) {
        switch (scale) {
            case 0: {
                return UnitsUtil.FACT_NONE;
            }
            case 15: {
                return UnitsUtil.FACT_NANOS;
            }
            case 14: {
                return UnitsUtil.FACT_MICROS;
            }
            case 13: {
                return UnitsUtil.FACT_MILLIS;
            }
            case 12: {
                return UnitsUtil.FACT_JIFFYS;
            }
            case 11: {
                return UnitsUtil.FACT_SECS;
            }
            case 10: {
                return UnitsUtil.FACT_MINS;
            }
            case 9: {
                return UnitsUtil.FACT_HOURS;
            }
            case 8: {
                return UnitsUtil.FACT_DAYS;
            }
            case 7: {
                return UnitsUtil.FACT_WEEKS;
            }
            case 6: {
                return UnitsUtil.FACT_YEARS;
            }
        }
        throw new IllegalArgumentException("Value did not have time based scale");
    }

    public UnitNumber parse(String val, Locale locale, ParseSpecifics specifics) throws ParseException {
        long curTime = System.currentTimeMillis();
        return new UnitNumber(TimeUtil.parseComplexTime(val, curTime, false), 5, 13);
    }

    public static class DateSpecifics
    extends FormatSpecifics {
        private DateFormat df;

        public void setDateFormat(DateFormat df) {
            this.df = df;
        }

        public DateFormat getDateFormat() {
            return this.df;
        }
    }
}

