/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.oracle;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hyperic.hq.product.JDBCControlPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.jdbc.DBUtil;

public class OracleControlPlugin
extends JDBCControlPlugin {
    private static final String _logCtx = OracleControlPlugin.class.getName();
    private String _segment;
    private String _tablespace;

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this._segment = config.getValue("segment");
        this._tablespace = config.getValue("tablespace");
    }

    protected Class getDriver() throws ClassNotFoundException {
        return Class.forName("oracle.jdbc.driver.OracleDriver");
    }

    protected Connection getConnection(String url, String user, String password) throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }

    public void doAction(String action) throws PluginException {
        Connection conn = null;
        try {
            conn = this.getConnection(this.url, this.user, this.password);
            if (!action.equals("Analyze")) {
                throw new PluginException("Action '" + action + "' not supported");
            }
            String query = "ANALYZE " + (OracleControlPlugin.isTable(conn, this._segment, this._tablespace) ? "TABLE " + this._segment : "INDEX " + this._segment) + " COMPUTE STATISTICS";
            this.execute(query);
        }
        catch (SQLException e) {
            try {
                this.setMessage(e.getMessage());
                throw new PluginException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.closeConnection((Object)_logCtx, conn);
                throw throwable;
            }
        }
        DBUtil.closeConnection((Object)_logCtx, (Connection)conn);
    }

    static boolean isTable(Connection conn, String segment, String tablespace) throws SQLException {
        block4: {
            ResultSet rs;
            Statement stmt;
            block5: {
                boolean bl;
                stmt = null;
                rs = null;
                try {
                    stmt = conn.createStatement();
                    String sql = "select segment_type from user_segments WHERE segment_name = '" + segment + "'" + " AND tablespace_name = '" + tablespace + "'";
                    rs = stmt.executeQuery(sql);
                    if (!rs.next()) break block4;
                    String type = rs.getString("segment_type");
                    if (!type.equalsIgnoreCase("table")) break block5;
                    bl = true;
                }
                catch (Throwable throwable) {
                    DBUtil.closeJDBCObjects((Object)_logCtx, null, (Statement)stmt, rs);
                    throw throwable;
                }
                DBUtil.closeJDBCObjects((Object)_logCtx, null, (Statement)stmt, (ResultSet)rs);
                return bl;
            }
            boolean bl = false;
            DBUtil.closeJDBCObjects((Object)_logCtx, null, (Statement)stmt, (ResultSet)rs);
            return bl;
        }
        throw new SQLException("ERROR: segment " + segment + " does not exist in tablespace " + tablespace);
    }
}

