/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import org.hyperic.hq.plugin.netservices.NetServicesCollector;
import org.hyperic.hq.product.PluginException;

public class InetAddressChecker
extends NetServicesCollector {
    private Method isReachable;
    private Object[] timeout;

    private InetAddress getAddress() throws IOException {
        return InetAddress.getByName(this.getHostname());
    }

    protected void init() throws PluginException {
        super.init();
        try {
            this.isReachable = InetAddress.class.getMethod("isReachable", Integer.TYPE);
        }
        catch (Exception e) {
            throw new PluginException("This service requires Java 1.5 or higher");
        }
        this.timeout = new Object[]{new Integer(this.getTimeoutMillis())};
        try {
            this.setSource(this.getAddress().toString());
        }
        catch (IOException e) {
            this.setSource(this.getHostname());
        }
    }

    public void collect() {
        try {
            this.startTime();
            InetAddress address = this.getAddress();
            Boolean avail = (Boolean)this.isReachable.invoke((Object)address, this.timeout);
            this.setAvailability(avail);
            this.endTime();
        }
        catch (Exception e) {
            this.setAvailability(false);
            this.setErrorMessage(e.getMessage());
        }
    }
}

