/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.netservices.NetServicesCollector;
import org.hyperic.util.ntp.NtpClient;
import org.hyperic.util.ntp.NtpResponse;

public class NTPCollector
extends NetServicesCollector {
    private static Log log = LogFactory.getLog((String)NTPCollector.class.getName());

    public void collect() {
        String host = this.getHostAddress();
        int port = this.getPort();
        NtpClient client = new NtpClient(host, port);
        client.setTimeout(this.getTimeoutMillis());
        try {
            this.startTime();
            NtpResponse response = client.getResponse();
            this.endTime();
            this.setAvailability(true);
            this.setValue("LocalClockOffset", response.getLocalClockOffset());
            this.setValue("RoundTripDelay", response.getRoundTripDelay());
            this.setValue("RootDelay", response.getRootDelay());
            this.setValue("RootDispersion", response.getRootDispersion());
        }
        catch (Exception e) {
            this.setAvailability(false);
            this.setErrorMessage(e.toString());
            log.error((Object)e.toString(), (Throwable)e);
        }
    }
}

