/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.netservices.NetServicesCollector;
import org.hyperic.util.ssh.SSHBase;

public class SSHCollector
extends NetServicesCollector {
    private static Log log = LogFactory.getLog((String)SSHCollector.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect() {
        String user = this.getUsername();
        String password = this.getPassword();
        String host = this.getHostAddress();
        int port = this.getPort();
        int timeout = this.getTimeoutMillis();
        if (user == null) {
            this.setErrorMessage("No username given, not performing check");
            this.setAvailability(false);
            return;
        }
        if (password == null) {
            this.setErrorMessage("No password given, not performing check");
            this.setAvailability(false);
            return;
        }
        SSHBase ssh = new SSHBase(user, password, host);
        ssh.setPort(port);
        ssh.setTimeout(timeout);
        Session session = null;
        try {
            this.startTime();
            session = ssh.openSession();
            this.setAvailability(true);
            this.endTime();
        }
        catch (JSchException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.setAvailability(false);
            this.endTime();
            this.setErrorMessage(e.getMessage());
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }
}

