/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.hq.measurement.data.DSNList;
import org.hyperic.hq.measurement.data.ValueList;
import org.hyperic.hq.product.MetricValue;

public class MeasurementReportConstructor {
    private HashMap clientIDs = new HashMap();

    public void addDataPoint(int clientID, int dsnID, MetricValue data) {
        ArrayList<MetricValue> valData;
        Integer iClientID = new Integer(clientID);
        Integer iDsnID = new Integer(dsnID);
        HashMap<Integer, ArrayList<MetricValue>> dsnMap = (HashMap<Integer, ArrayList<MetricValue>>)this.clientIDs.get(iClientID);
        if (dsnMap == null) {
            dsnMap = new HashMap<Integer, ArrayList<MetricValue>>();
            this.clientIDs.put(iClientID, dsnMap);
        }
        if ((valData = (ArrayList<MetricValue>)dsnMap.get(iDsnID)) == null) {
            valData = new ArrayList<MetricValue>();
            dsnMap.put(iDsnID, valData);
        }
        valData.add(data);
    }

    public DSNList[] constructDSNList() {
        DSNList[] cids = new DSNList[this.clientIDs.size()];
        int cidIdx = 0;
        for (Map.Entry ent : this.clientIDs.entrySet()) {
            Integer clientId = (Integer)ent.getKey();
            HashMap dsnMap = (HashMap)ent.getValue();
            ValueList[] dsns = new ValueList[dsnMap.size()];
            int dsnIdx = 0;
            for (Map.Entry dsnEnt : dsnMap.entrySet()) {
                Integer dsnID = (Integer)dsnEnt.getKey();
                ArrayList vals = (ArrayList)dsnEnt.getValue();
                MetricValue[] data = new MetricValue[vals.size()];
                int dataIdx = 0;
                for (MetricValue val : vals) {
                    data[dataIdx++] = val;
                }
                dsns[dsnIdx] = new ValueList();
                dsns[dsnIdx].setDsnId(dsnID);
                dsns[dsnIdx].setValues(data);
                ++dsnIdx;
            }
            cids[cidIdx] = new DSNList();
            cids[cidIdx].setClientId(clientId);
            cids[cidIdx].setDsns(dsns);
            ++cidIdx;
        }
        return cids;
    }

    public static void dumpReport(DSNList[] cids) {
        for (int i = 0; i < cids.length; ++i) {
            ValueList[] dsns = cids[i].getDsns();
            System.out.println(cids[i].getClientId());
            for (int j = 0; j < dsns.length; ++j) {
                MetricValue[] data = dsns[j].getValues();
                System.out.println("\t" + dsns[j].getDsnId());
                for (int k = 0; k < data.length; ++k) {
                    System.out.println("\t\t" + data[k].getTimestamp() + " " + data[k].getValue());
                }
            }
        }
    }

    public static void main(String[] args) {
        MeasurementReportConstructor c = new MeasurementReportConstructor();
        c.addDataPoint(1, 123, new MetricValue(3L, 4L));
        c.addDataPoint(1, 123, new MetricValue(2L, 75L));
        c.addDataPoint(2, 456, new MetricValue(8L, 67L));
        c.addDataPoint(2, 789, new MetricValue(9L, 172L));
        c.addDataPoint(2, 456, new MetricValue(100L, 59L));
        c.addDataPoint(2, 789, new MetricValue(101L, 84L));
        MeasurementReportConstructor.dumpReport(c.constructDSNList());
    }
}

