/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectionUtil {
    private static Log log = LogFactory.getLog((String)DetectionUtil.class.getName());
    private static Sigar sigarImpl = null;
    private static SigarProxy sigar = null;
    private static final String OS_TYPE = System.getProperty("os.name").toLowerCase();
    private static final boolean IS_WINDOWS = OS_TYPE.contains("win");
    private static final boolean IS_UNIX = OS_TYPE.contains("nix") || OS_TYPE.contains("nux") || OS_TYPE.contains("sunos") || OS_TYPE.contains("mac os x");

    public static void populateListeningPorts(long pid, ConfigResponse cf, boolean recursive) {
        HashSet<Long> pids = new HashSet<Long>();
        pids.add(pid);
        if (recursive) {
            pids.addAll(DetectionUtil.getAllChildPid(pid));
        }
        DetectionUtil.populateListeningPorts(pids, cf);
    }

    public static void populateListeningPorts(Set<Long> pids, ConfigResponse cf) {
        if (pids.isEmpty()) {
            return;
        }
        if (IS_WINDOWS) {
            DetectionUtil.populatePortsOnWindows(pids, cf);
        } else if (IS_UNIX) {
            DetectionUtil.populatePortsOnUnix(pids, cf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populatePortsOnUnix(Set<Long> pids, ConfigResponse cf) {
        String cmd = "netstat -lnptu";
        StringBuilder pidsStr = new StringBuilder();
        for (Long pid : pids) {
            pidsStr.append(',').append(pid);
        }
        HashSet<String> ports = new HashSet<String>();
        BufferedReader input = null;
        try {
            String line;
            Process process = Runtime.getRuntime().exec(cmd);
            input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (!line.contains("LISTEN")) continue;
                try {
                    line = line.trim();
                    String pid = line.substring(line.lastIndexOf(" "));
                    pid = pid.trim();
                    pid = pid.substring(0, pid.indexOf("/"));
                    if (!pids.contains(Long.valueOf(pid))) continue;
                    line = line.substring(line.indexOf(":"));
                    line = line.substring(0, line.indexOf(" "));
                    line = line.substring(line.lastIndexOf(":") + 1);
                    if (!DetectionUtil.isNumber(line = line.trim())) continue;
                    ports.add(line);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error populating ports for '" + pidsStr + "' "), (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
        DetectionUtil.updatePortsInConfigResponse(cf, ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populatePortsOnWindows(Set<Long> pids, ConfigResponse cf) {
        String cmd = "netstat -ano";
        StringBuilder pidsStr = new StringBuilder();
        for (Long pid : pids) {
            pidsStr.append(',').append(pid);
        }
        HashSet<String> ports = new HashSet<String>();
        BufferedReader input = null;
        try {
            String line;
            Process process = Runtime.getRuntime().exec(cmd);
            input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (!line.trim().startsWith("TCP") && !line.startsWith("UDP") || !line.contains("LISTENING")) continue;
                try {
                    long pid = Long.valueOf(line.trim().substring(line.trim().lastIndexOf(" ")).trim());
                    if (!pids.contains(pid)) continue;
                    if (line.contains("[::")) {
                        line = line.replaceAll("[::", "").trim();
                    }
                    line = line.substring(line.indexOf(":") + 1);
                    line = line.substring(0, line.indexOf(" "));
                    if (!DetectionUtil.isNumber(line = line.trim())) continue;
                    ports.add(line);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error populating ports for '" + pidsStr + "' "), (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
        DetectionUtil.updatePortsInConfigResponse(cf, ports);
    }

    private static void updatePortsInConfigResponse(ConfigResponse cf, Set<String> ports) {
        if (!ports.isEmpty()) {
            StringBuilder portsStr = new StringBuilder();
            for (String port : ports) {
                portsStr.append(',').append(port);
            }
            cf.setValue("listen.ports", portsStr.substring(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> getAllChildPid(long parentPid) {
        HashSet<Long> childPids = new HashSet<Long>();
        if (IS_UNIX) {
            String cmd = "ps -o pid --no-headers --ppid " + String.valueOf(parentPid);
            BufferedReader input = null;
            try {
                String line;
                Process process = Runtime.getRuntime().exec(cmd);
                input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = input.readLine()) != null) {
                    if ((line = line.trim()).equals("") || !DetectionUtil.isNumber(line)) continue;
                    Long childPid = Long.valueOf(line);
                    childPids.addAll(DetectionUtil.getAllChildPid(childPid));
                    childPids.add(childPid);
                }
            }
            catch (Exception e) {
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                }
            }
        } else if (IS_WINDOWS) {
            String cmd = "wmic process get processid,parentprocessid";
            BufferedReader input = null;
            try {
                String line;
                Process process = Runtime.getRuntime().exec("wmic process get processid,parentprocessid");
                input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                if (!input.ready()) {
                    HashSet<Long> childPid = childPids;
                    return childPid;
                }
                long lPpid = -1L;
                String sPpid = "";
                String sCpid = "";
                long lCpid = -1L;
                while ((line = input.readLine()) != null) {
                    try {
                        sPpid = (line = line.trim()).substring(0, line.indexOf(" "));
                        lPpid = Long.valueOf(sPpid);
                        if (parentPid != lPpid) continue;
                        sCpid = line.substring(line.indexOf(" ")).trim();
                        lCpid = Long.valueOf(sCpid);
                        childPids.addAll(DetectionUtil.getAllChildPid(lCpid));
                        childPids.add(lCpid);
                    }
                    catch (Exception e) {}
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                }
            }
        }
        return childPids;
    }

    private static boolean isNumber(String value) {
        try {
            Long.valueOf(value);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    protected static SigarProxy getSigar() {
        if (sigar == null) {
            int timeout = 600000;
            sigarImpl = new Sigar();
            sigar = SigarProxyCache.newInstance((Sigar)sigarImpl, (int)timeout);
        }
        return sigar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMacs(String name) throws IOException {
        String cmd = "@echo Name            IsManagementOs VMName SwitchName                                                                 MacAddress   Status      IPAddresses";
        BufferedReader input = null;
        ArrayList<String> macs = new ArrayList<String>();
        try {
            String line;
            Process process = Runtime.getRuntime().exec(cmd);
            input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            int i = -1;
            while ((line = input.readLine()) != null) {
                if ("".equals(line = line.trim())) continue;
                if (i == -1) {
                    i = line.indexOf("MacAddress");
                    continue;
                }
                macs.add(line.substring(i, line.indexOf(" ", i)));
            }
            StringBuilder sb = new StringBuilder();
            for (String mac : macs) {
                sb.append(',').append(mac);
            }
            String string = sb.toString().substring(1);
            return string;
        }
        catch (Exception e) {
            log.error((Object)e);
            String string = null;
            return string;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        String in = "Name            IsManagementOs VMName SwitchName                                                                 MacAddress   Status      IPAddresses";
        BufferedReader input = null;
        ArrayList macs = new ArrayList();
        Process process = Runtime.getRuntime().exec("@echo Name            IsManagementOs VMName SwitchName                                                                 MacAddress   Status      IPAddresses");
        try {
            String line;
            input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            int i = -1;
            while ((line = input.readLine()) != null) {
                line = line.trim();
                System.out.println(line);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    public static Set<String> getWMIObj(String namespace, String wmiObjName, Map<String, String> filters, String col, String name) throws PluginException {
        if (wmiObjName == null || "".equals(wmiObjName)) {
            throw new PluginException("object property not specified in the template of " + name);
        }
        StringBuilder sb = new StringBuilder().append("wmic /NAMESPACE:\\\\" + namespace + " path ").append(wmiObjName);
        if (filters != null && !filters.isEmpty()) {
            sb.append(" WHERE \"");
            int num = 0;
            for (Map.Entry<String, String> filterEntry : filters.entrySet()) {
                String filterFieldAndVal = filterEntry.getKey();
                String operator = filterEntry.getValue();
                int i = filterFieldAndVal.indexOf("-");
                sb.append(filterFieldAndVal.substring(0, i)).append(" ").append(operator).append(" '").append(filterFieldAndVal.substring(i + 1, filterFieldAndVal.length())).append("'");
                if (++num >= filters.size()) continue;
                sb.append(" and ");
            }
            sb.append("\"");
        }
        sb.append(" get");
        if (col != null && !"".equals(col)) {
            sb.append(" " + col);
        }
        sb.append(" /format:textvaluelist.xsl");
        String cmd = sb.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("cmd=" + cmd));
        }
        BufferedReader input = null;
        try {
            String line;
            Process process = Runtime.getRuntime().exec(cmd);
            input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            HashSet<String> obj = new HashSet<String>();
            while ((line = input.readLine()) != null) {
                line = line.trim();
                StringTokenizer st = new StringTokenizer(line, "=");
                while (st.hasMoreElements()) {
                    String k = ((String)st.nextElement()).trim();
                    String v = ((String)st.nextElement()).trim();
                    obj.add(v);
                }
            }
            HashSet<String> hashSet = obj;
            return hashSet;
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    throw new PluginException(e);
                }
            }
        }
    }
}

