/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.util.StringTokenizer;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.util.config.ConfigResponse;

public class MxMeasurementPlugin
extends MeasurementPlugin {
    private double doubleValue(Object obj) throws PluginException {
        try {
            return Double.valueOf(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new PluginException("Cannot convert '" + obj + "' to double");
        }
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        Object objectVal = MxUtil.getValue(metric);
        String stringVal = objectVal.toString();
        String mappedVal = this.getTypeProperty(metric.getAttributeName() + "." + stringVal);
        double doubleVal = mappedVal != null ? this.doubleValue(mappedVal) : (objectVal instanceof Number ? ((Number)objectVal).doubleValue() : (objectVal instanceof Boolean ? ((Boolean)objectVal != false ? 1.0 : 0.0) : this.doubleValue(stringVal)));
        if (doubleVal == -1.0) {
            return new MetricValue(Double.NaN);
        }
        return new MetricValue(doubleVal);
    }

    public String translate(String template, ConfigResponse config) {
        StringBuffer expanded = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(template, ":");
        if (tok.countTokens() < 4) {
            String msg = "Malformed metric template: " + template;
            throw new IllegalArgumentException(msg);
        }
        expanded.append(tok.nextToken()).append(':');
        expanded.append(tok.nextToken()).append(':');
        expanded.append(MxUtil.expandObjectName(tok.nextToken()));
        expanded.append(':').append(tok.nextToken());
        String connProps = tok.hasMoreTokens() ? tok.nextToken() : "jmx.url=%jmx.url%,jmx.username=%jmx.username%,jmx.password=%jmx.password%";
        expanded.append(':').append(connProps);
        while (tok.hasMoreTokens()) {
            expanded.append(':').append(tok.nextToken());
        }
        return super.translate(expanded.toString(), config);
    }
}

